/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morecollectables.fluid;

import net.mcreator.morecollectables.init.MorecollectablesModBlocks;
import net.mcreator.morecollectables.init.MorecollectablesModFluidTypes;
import net.mcreator.morecollectables.init.MorecollectablesModFluids;
import net.mcreator.morecollectables.init.MorecollectablesModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class CleanWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)MorecollectablesModFluidTypes.CLEAN_WATER_TYPE.get(), () -> (Fluid)MorecollectablesModFluids.CLEAN_WATER.get(), () -> (Fluid)MorecollectablesModFluids.FLOWING_CLEAN_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)MorecollectablesModItems.CLEAN_WATER_BUCKET.get()).block(() -> (LiquidBlock)MorecollectablesModBlocks.CLEAN_WATER.get());

    private CleanWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    public static class Flowing
    extends CleanWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends CleanWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

