/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.AuroraLogger;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.events.user.AuroraUserLoadedEvent;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.quests.api.AuroraQuestsPlugin;
import gg.auroramc.quests.api.data.QuestData;
import gg.auroramc.quests.api.event.BukkitEventBus;
import gg.auroramc.quests.api.event.QuestCompletedEvent;
import gg.auroramc.quests.api.factory.ObjectiveFactory;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.profile.ProfileManager;
import gg.auroramc.quests.api.quest.QuestDefinition;
import gg.auroramc.quests.api.questpool.Pool;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.api.questpool.PoolManager;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.command.CommandManager;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.config.ConfigManager;
import gg.auroramc.quests.config.MessageConfig;
import gg.auroramc.quests.hooks.HookManager;
import gg.auroramc.quests.libs.bstats.bukkit.Metrics;
import gg.auroramc.quests.libs.bstats.charts.AdvancedPie;
import gg.auroramc.quests.menu.PoolMenu;
import gg.auroramc.quests.objective.BlockBreakObjective;
import gg.auroramc.quests.objective.BlockLootObjective;
import gg.auroramc.quests.objective.BlockPlaceObjective;
import gg.auroramc.quests.objective.BlockShearLootObjective;
import gg.auroramc.quests.objective.BlockShearObjective;
import gg.auroramc.quests.objective.BreakItemObjective;
import gg.auroramc.quests.objective.BreedingObjective;
import gg.auroramc.quests.objective.BrewingObjective;
import gg.auroramc.quests.objective.BuildingObjective;
import gg.auroramc.quests.objective.BuyObjective;
import gg.auroramc.quests.objective.BuyWorthObjective;
import gg.auroramc.quests.objective.CommandObjective;
import gg.auroramc.quests.objective.CompleteDungeonObjective;
import gg.auroramc.quests.objective.ConsumeObjective;
import gg.auroramc.quests.objective.CraftObjective;
import gg.auroramc.quests.objective.DealDamageObjective;
import gg.auroramc.quests.objective.EnchantObjective;
import gg.auroramc.quests.objective.EnterRegionObjective;
import gg.auroramc.quests.objective.EnterWorldObjective;
import gg.auroramc.quests.objective.EntityLootObjective;
import gg.auroramc.quests.objective.ExpEarnObjective;
import gg.auroramc.quests.objective.FarmingObjective;
import gg.auroramc.quests.objective.FishingObjective;
import gg.auroramc.quests.objective.IslandJoinObjective;
import gg.auroramc.quests.objective.IslandLevelObjective;
import gg.auroramc.quests.objective.IslandUpgradeObjective;
import gg.auroramc.quests.objective.IslandWorthObjective;
import gg.auroramc.quests.objective.LevelledMobKillObjective;
import gg.auroramc.quests.objective.MilkingObjective;
import gg.auroramc.quests.objective.MobKillObjective;
import gg.auroramc.quests.objective.NpcInteractObjective;
import gg.auroramc.quests.objective.PlaceholderObjective;
import gg.auroramc.quests.objective.PlayerKillObjective;
import gg.auroramc.quests.objective.SellObjective;
import gg.auroramc.quests.objective.SellWorthObjective;
import gg.auroramc.quests.objective.ShearLootObjective;
import gg.auroramc.quests.objective.ShearObjective;
import gg.auroramc.quests.objective.SmeltObjective;
import gg.auroramc.quests.objective.TakeItemObjective;
import gg.auroramc.quests.objective.TameObjective;
import gg.auroramc.quests.objective.TravelObjective;
import gg.auroramc.quests.parser.PoolParser;
import gg.auroramc.quests.placeholder.QuestPlaceholderHandler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class AuroraQuests
extends AuroraQuestsPlugin
implements Listener {
    private boolean loaded = false;
    private static AuroraQuests instance;
    private static AuroraLogger l;
    private ConfigManager configManager;
    private LocalizationProvider localizationProvider;
    private CommandManager commandManager;
    private ScheduledTask unlockTask;
    private BukkitEventBus bukkitEventBus;
    private final Set<Player> toLoad = new HashSet<Player>();

    public static AuroraLogger logger() {
        return l;
    }

    public void onLoad() {
        instance = this;
        AuroraQuestsPlugin.instance = this;
        this.configManager = new ConfigManager(this);
        this.profileManager = new ProfileManager();
        this.poolManager = new PoolManager();
        this.bukkitEventBus = new BukkitEventBus();
        this.registerObjectives();
        l = AuroraAPI.createLogger((String)"AuroraQuests", () -> this.configManager.getConfig().getDebug());
        this.configManager.reload();
        for (PoolConfig pool : this.configManager.getQuestPools().values()) {
            if (pool.getType().equals("global") && !this.configManager.getConfig().getLeaderboards().getIncludeGlobal().booleanValue()) continue;
            AuroraAPI.getLeaderboards().registerBoard("quests_" + pool.getId(), user -> ((QuestData)user.getData(QuestData.class)).getCompletedCount(pool.getId()), lb -> AuroraAPI.formatNumber((long)Double.valueOf(lb.getValue()).longValue()), this.configManager.getConfig().getLeaderboards().getCacheSize().intValue(), (double)this.configManager.getConfig().getLeaderboards().getMinCompleted().intValue());
        }
        HookManager.loadHooks(this);
    }

    public void onEnable() {
        this.localizationProvider = new LocalizationProvider(Aurora.getLanguageProvider(), this.configManager.getConfig().getPerPlayerLocale().booleanValue());
        for (Map.Entry<Locale, MessageConfig> msg : this.configManager.getMessageConfigs().entrySet()) {
            this.localizationProvider.setLocaleValues(msg.getKey(), msg.getValue().toFlatMap());
        }
        AuroraAPI.getUserManager().registerUserDataHolder(QuestData.class);
        AuroraAPI.registerPlaceholderHandler((PlaceholderHandler)new QuestPlaceholderHandler());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.commandManager = new CommandManager(this);
        this.commandManager.reload();
        HookManager.enableHooks(this);
        ArrayList<Pool> pools = new ArrayList<Pool>();
        for (PoolConfig pool : this.configManager.getQuestPools().values()) {
            pools.add(PoolParser.parse(pool, this.poolManager.getRewardFactory()));
        }
        this.poolManager.reload(pools);
        this.loaded = true;
        this.loadPlayers();
        Bukkit.getGlobalRegionScheduler().run((Plugin)this, task -> this.reloadUnlockTask());
        CommandDispatcher.registerActionHandler((String)"quest-pool", (player, input) -> {
            String[] split = input.split("---");
            String poolId = split[0].trim();
            Profile profile = this.profileManager.getProfile((Player)player);
            if (profile == null) {
                return;
            }
            QuestPool pool = profile.getQuestPool(poolId);
            if (pool == null) {
                return;
            }
            if (split.length > 1) {
                new PoolMenu(profile, pool, () -> CommandDispatcher.dispatch((Player)player, (String)split[1].trim())).open();
            } else {
                new PoolMenu(profile, pool).open();
            }
        });
        new Metrics(this, 23779).addCustomChart(new AdvancedPie("objective_type_distribution", () -> {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (Pool pool : this.poolManager.getPools()) {
                for (QuestDefinition quest : pool.getDefinition().getQuests().values()) {
                    for (ObjectiveDefinition objective : quest.getTasks().values()) {
                        data.merge(objective.getTask(), 1, Integer::sum);
                    }
                }
            }
            return data;
        }));
    }

    public void reload() {
        this.configManager.reload();
        this.localizationProvider.clear();
        for (Map.Entry<Locale, MessageConfig> msg : this.configManager.getMessageConfigs().entrySet()) {
            this.localizationProvider.setLocaleValues(msg.getKey(), msg.getValue().toFlatMap());
        }
        this.commandManager.reload();
        ArrayList<Pool> pools = new ArrayList<Pool>();
        for (PoolConfig pool : this.configManager.getQuestPools().values()) {
            pools.add(PoolParser.parse(pool, this.poolManager.getRewardFactory()));
        }
        this.poolManager.reload(pools);
        this.reloadUnlockTask();
        this.profileManager.getProfiles().forEach(p -> p.reload(true));
    }

    public void onDisable() {
        this.commandManager.unregisterCommands();
        try {
            l.info("Shutting down scheduler...");
            StdSchedulerFactory.getDefaultScheduler().shutdown(true);
        }
        catch (SchedulerException e) {
            l.severe("Failed to shutdown scheduler: " + e.getMessage());
        }
        if (this.unlockTask != null && !this.unlockTask.isCancelled()) {
            this.unlockTask.cancel();
        }
    }

    private void registerObjectives() {
        ObjectiveFactory.registerObjective("BLOCK_LOOT", BlockLootObjective.class);
        ObjectiveFactory.registerObjective("BLOCK_BREAK", BlockBreakObjective.class);
        ObjectiveFactory.registerObjective("BLOCK_SHEAR", BlockShearObjective.class);
        ObjectiveFactory.registerObjective("BLOCK_SHEAR_LOOT", BlockShearLootObjective.class);
        ObjectiveFactory.registerObjective("BREED", BreedingObjective.class);
        ObjectiveFactory.registerObjective("BREW", BrewingObjective.class);
        ObjectiveFactory.registerObjective("BUILD", BuildingObjective.class);
        ObjectiveFactory.registerObjective("BLOCK_PLACE", BlockPlaceObjective.class);
        ObjectiveFactory.registerObjective("RUN_COMMAND", CommandObjective.class);
        ObjectiveFactory.registerObjective("CONSUME", ConsumeObjective.class);
        ObjectiveFactory.registerObjective("CRAFT", CraftObjective.class);
        ObjectiveFactory.registerObjective("ENCHANT", EnchantObjective.class);
        ObjectiveFactory.registerObjective("EARN_EXP", ExpEarnObjective.class);
        ObjectiveFactory.registerObjective("FARM", FarmingObjective.class);
        ObjectiveFactory.registerObjective("FISH", FishingObjective.class);
        ObjectiveFactory.registerObjective("MILK", MilkingObjective.class);
        ObjectiveFactory.registerObjective("KILL_MOB", MobKillObjective.class);
        ObjectiveFactory.registerObjective("KILL_LEVELLED_MOB", LevelledMobKillObjective.class);
        ObjectiveFactory.registerObjective("ENTITY_LOOT", EntityLootObjective.class);
        ObjectiveFactory.registerObjective("KILL_PLAYER", PlayerKillObjective.class);
        ObjectiveFactory.registerObjective("SHEAR", ShearObjective.class);
        ObjectiveFactory.registerObjective("SHEAR_LOOT", ShearLootObjective.class);
        ObjectiveFactory.registerObjective("SMELT", SmeltObjective.class);
        ObjectiveFactory.registerObjective("TAME", TameObjective.class);
        ObjectiveFactory.registerObjective("INTERACT_NPC", NpcInteractObjective.class);
        ObjectiveFactory.registerObjective("ENTER_REGION", EnterRegionObjective.class);
        ObjectiveFactory.registerObjective("COMPLETE_DUNGEON", CompleteDungeonObjective.class);
        ObjectiveFactory.registerObjective("SELL_WORTH", SellWorthObjective.class);
        ObjectiveFactory.registerObjective("BUY_WORTH", BuyWorthObjective.class);
        ObjectiveFactory.registerObjective("SELL", SellObjective.class);
        ObjectiveFactory.registerObjective("BUY", BuyObjective.class);
        ObjectiveFactory.registerObjective("JOIN_ISLAND", IslandJoinObjective.class);
        ObjectiveFactory.registerObjective("REACH_ISLAND_WORTH", IslandWorthObjective.class);
        ObjectiveFactory.registerObjective("REACH_ISLAND_LEVEL", IslandLevelObjective.class);
        ObjectiveFactory.registerObjective("UPGRADE_ISLAND", IslandUpgradeObjective.class);
        ObjectiveFactory.registerObjective("TAKE_ITEM", TakeItemObjective.class);
        ObjectiveFactory.registerObjective("PLACEHOLDER", PlaceholderObjective.class);
        ObjectiveFactory.registerObjective("ENTER_WORLD", EnterWorldObjective.class);
        ObjectiveFactory.registerObjective("DEAL_DAMAGE", DealDamageObjective.class);
        ObjectiveFactory.registerObjective("BREAK_ITEM", BreakItemObjective.class);
        ObjectiveFactory.registerObjective("TRAVEL", TravelObjective.class);
    }

    private void reloadUnlockTask() {
        Config.UnlockTaskConfig cf = this.configManager.getConfig().getUnlockTask();
        if (!cf.getEnabled().booleanValue()) {
            if (this.unlockTask != null && !this.unlockTask.isCancelled()) {
                this.unlockTask.cancel();
                this.unlockTask = null;
            }
            return;
        }
        this.unlockTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this, task -> this.profileManager.getProfiles().forEach(profile -> {
            for (QuestPool pool : profile.getQuestPools()) {
                pool.unlock(false);
                pool.rollIfNecessary(true);
                pool.startQuests();
            }
        }), (long)cf.getInterval().intValue(), (long)cf.getInterval().intValue(), TimeUnit.SECONDS);
    }

    @EventHandler
    public void onUserLoaded(AuroraUserLoadedEvent event) {
        if (event.getUser().getPlayer() != null) {
            if (this.loaded) {
                this.profileManager.createProfile(event.getUser());
            } else {
                this.toLoad.add(event.getUser().getPlayer());
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.profileManager.destroyProfile(event.getPlayer().getUniqueId());
        this.toLoad.remove(event.getPlayer());
    }

    @EventHandler
    public void onQuestComplete(QuestCompletedEvent event) {
        Profile profile = this.profileManager.getProfile(event.getPlayer());
        for (QuestPool pool : profile.getQuestPools()) {
            pool.unlock(false);
            pool.rollIfNecessary(true);
            pool.startQuests();
        }
    }

    private void loadPlayers() {
        for (Player player : this.toLoad) {
            AuroraUser user = AuroraUser.get((UUID)player.getUniqueId());
            this.profileManager.createProfile(user);
        }
        this.toLoad.clear();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public ScheduledTask getUnlockTask() {
        return this.unlockTask;
    }

    public BukkitEventBus getBukkitEventBus() {
        return this.bukkitEventBus;
    }

    public Set<Player> getToLoad() {
        return this.toLoad;
    }

    public static AuroraQuests getInstance() {
        return instance;
    }

    public LocalizationProvider getLocalizationProvider() {
        return this.localizationProvider;
    }
}

