/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.quests.api.data.PoolRollData;
import gg.auroramc.quests.api.quest.QuestDefinition;
import gg.auroramc.quests.api.questpool.Pool;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class QuestData
extends UserDataHolder {
    private final Map<String, PoolRollData> rolledQuests = Maps.newConcurrentMap();
    private final Map<String, Map<String, Map<String, Double>>> progression = Maps.newConcurrentMap();
    private final Map<String, Set<String>> completedQuests = Maps.newConcurrentMap();
    private final Map<String, Long> completedCount = Maps.newConcurrentMap();
    private final Map<String, Set<String>> questUnlocks = Maps.newConcurrentMap();
    private final Set<String> poolUnlocks = Sets.newConcurrentHashSet();

    public PoolRollData getPoolRollData(String poolId) {
        return this.rolledQuests.get(poolId);
    }

    public void unlockPool(String poolId) {
        this.poolUnlocks.add(poolId);
        this.dirty.set(true);
    }

    public boolean isPoolUnlocked(String poolId) {
        return this.poolUnlocks.contains(poolId);
    }

    public void setRolledQuests(String poolId, List<String> quests) {
        this.rolledQuests.put(poolId, new PoolRollData(System.currentTimeMillis(), quests));
        this.completedQuests.computeIfAbsent(poolId, k -> Sets.newConcurrentHashSet()).clear();
        this.progression.computeIfAbsent(poolId, k -> Maps.newConcurrentMap()).clear();
        this.dirty.set(true);
    }

    public void setQuestStartUnlock(String poolId, String questId) {
        this.questUnlocks.computeIfAbsent(poolId, k -> Sets.newConcurrentHashSet()).add(questId);
        this.dirty.set(true);
    }

    public boolean isQuestStartUnlocked(String poolId, String questId) {
        return this.hasCompletedQuest(poolId, questId) || this.questUnlocks.computeIfAbsent(poolId, k -> Sets.newConcurrentHashSet()).contains(questId);
    }

    public void removeQuestStartUnlock(String poolId, String questId) {
        this.questUnlocks.computeIfAbsent(poolId, k -> Sets.newConcurrentHashSet()).remove(questId);
        this.dirty.set(true);
    }

    public void progress(String poolId, String questId, String taskId, double count) {
        this.progression.computeIfAbsent(poolId, k -> Maps.newConcurrentMap()).computeIfAbsent(questId, k -> Maps.newConcurrentMap()).merge(taskId, count, (a, b) -> Math.max(a + b, 0.0));
        this.dirty.set(true);
    }

    public void setProgress(String poolId, String questId, String taskId, double count) {
        this.progression.computeIfAbsent(poolId, k -> Maps.newConcurrentMap()).computeIfAbsent(questId, k -> Maps.newConcurrentMap()).put(taskId, count);
        this.dirty.set(true);
    }

    public void completeQuest(String poolId, String questId) {
        this.completedQuests.computeIfAbsent(poolId, k -> new HashSet()).add(questId);
        this.dirty.set(true);
    }

    public void resetQuestProgress(String poolId, String questId) {
        Set completesQuests = this.completedQuests.computeIfAbsent(poolId, k -> new HashSet());
        completesQuests.remove(questId);
        this.progression.computeIfAbsent(poolId, k -> Maps.newConcurrentMap()).remove(questId);
        this.dirty.set(true);
    }

    public void resetTaskProgress(String poolId, String questId, String taskId) {
        Set completesQuests = this.completedQuests.computeIfAbsent(poolId, k -> new HashSet());
        completesQuests.remove(questId);
        Map progression = (Map)this.progression.computeIfAbsent(poolId, k -> Maps.newConcurrentMap()).get(questId);
        if (progression != null) {
            progression.remove(taskId);
        }
        this.dirty.set(true);
    }

    public boolean hasCompletedQuest(String poolId, String questId) {
        return this.completedQuests.computeIfAbsent(poolId, k -> Sets.newConcurrentHashSet()).contains(questId);
    }

    public double getProgression(String poolId, String questId, String taskId) {
        return this.progression.computeIfAbsent(poolId, k -> Maps.newConcurrentMap()).computeIfAbsent(questId, k -> Maps.newConcurrentMap()).computeIfAbsent(taskId, k -> 0.0);
    }

    public void clearPoolProgression(String poolId) {
        this.progression.remove(poolId);
    }

    public void incrementCompletedCount(String poolId) {
        this.completedCount.merge(poolId, 1L, Long::sum);
        this.dirty.set(true);
    }

    public long getCompletedCount(String poolId) {
        return this.completedCount.getOrDefault(poolId, 0L);
    }

    public NamespacedId getId() {
        return NamespacedId.fromDefault((String)"quests");
    }

    public void serializeInto(ConfigurationSection data) {
        data.getKeys(false).forEach(key -> data.set(key, null));
        ConfigurationSection rolledSection = data.createSection("rolled");
        for (Map.Entry<String, PoolRollData> entry : this.rolledQuests.entrySet()) {
            ConfigurationSection configurationSection = rolledSection.createSection(entry.getKey());
            configurationSection.set("time", (Object)entry.getValue().timestamp());
            configurationSection.set("quests", entry.getValue().quests());
        }
        ConfigurationSection progressionSection = data.createSection("progression");
        for (Map.Entry<String, Map<String, Map<String, Double>>> entry : this.progression.entrySet()) {
            ConfigurationSection poolSection = progressionSection.createSection(entry.getKey());
            for (Map.Entry<String, Map<String, Double>> questEntry : entry.getValue().entrySet()) {
                ConfigurationSection questSection = poolSection.createSection(questEntry.getKey());
                for (Map.Entry<String, Double> taskEntry : questEntry.getValue().entrySet()) {
                    if (!(taskEntry.getValue() > 0.0)) continue;
                    questSection.set(taskEntry.getKey(), (Object)taskEntry.getValue());
                }
            }
        }
        for (Map.Entry<String, Set<String>> entry : this.questUnlocks.entrySet()) {
            for (String questEntry : entry.getValue()) {
                data.set("progression." + entry.getKey() + "." + questEntry + ".unlocked", (Object)true);
            }
        }
        data.set("pool_unlocks", this.poolUnlocks.stream().toList());
        for (Map.Entry<String, Set<String>> entry : this.completedQuests.entrySet()) {
            for (String questEntry : entry.getValue()) {
                data.set("progression." + entry.getKey() + "." + questEntry, (Object)true);
            }
        }
        ConfigurationSection configurationSection = data.createSection("completed_count");
        for (Map.Entry<String, Long> entry : this.completedCount.entrySet()) {
            configurationSection.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    public void initFrom(@Nullable ConfigurationSection data) {
        ConfigurationSection completedCountSection;
        ConfigurationSection progressionSection;
        if (data == null) {
            return;
        }
        ConfigurationSection rolledSection = data.getConfigurationSection("rolled");
        if (rolledSection != null) {
            for (Object key : rolledSection.getKeys(false)) {
                ConfigurationSection poolSection = rolledSection.getConfigurationSection((String)key);
                List quests = poolSection.getStringList("quests");
                this.rolledQuests.put((String)key, new PoolRollData(poolSection.getLong("time"), quests));
            }
        }
        if ((progressionSection = data.getConfigurationSection("progression")) != null) {
            for (String poolKey : progressionSection.getKeys(false)) {
                ConfigurationSection poolSection = progressionSection.getConfigurationSection(poolKey);
                for (String questKey : poolSection.getKeys(false)) {
                    if (poolSection.isBoolean(questKey)) {
                        this.completedQuests.computeIfAbsent(poolKey, k -> Sets.newConcurrentHashSet()).add(questKey);
                        continue;
                    }
                    ConfigurationSection questSection = poolSection.getConfigurationSection(questKey);
                    for (String taskKey : questSection.getKeys(false)) {
                        if (taskKey.equals("unlocked")) {
                            this.questUnlocks.computeIfAbsent(poolKey, k -> Sets.newConcurrentHashSet()).add(questKey);
                            continue;
                        }
                        double count = questSection.getDouble(taskKey, 0.0);
                        this.progression.computeIfAbsent(poolKey, k -> Maps.newConcurrentMap()).computeIfAbsent(questKey, k -> Maps.newConcurrentMap()).put(taskKey, count);
                    }
                }
            }
        }
        if ((completedCountSection = data.getConfigurationSection("completed_count")) != null) {
            for (String key : completedCountSection.getKeys(false)) {
                this.completedCount.put(key, completedCountSection.getLong(key));
            }
        }
        this.poolUnlocks.addAll(data.getStringList("pool_unlocks"));
    }

    public void purgeInvalidData(Collection<Pool> pools) {
        Set poolIds = pools.stream().map(Pool::getId).collect(Collectors.toSet());
        this.completedCount.keySet().removeIf(poolId -> !poolIds.contains(poolId));
        this.progression.keySet().removeIf(poolId -> !poolIds.contains(poolId));
        this.questUnlocks.keySet().removeIf(poolId -> !poolIds.contains(poolId));
        this.rolledQuests.keySet().removeIf(poolId -> !poolIds.contains(poolId));
        this.completedQuests.keySet().removeIf(poolId -> !poolIds.contains(poolId));
        this.poolUnlocks.removeIf(poolId -> !poolIds.contains(poolId));
        for (Pool pool : pools) {
            Set questIds = pool.getDefinition().getQuests().values().stream().map(QuestDefinition::getId).collect(Collectors.toSet());
            if (this.progression.containsKey(pool.getId())) {
                this.progression.get(pool.getId()).keySet().removeIf(id -> !questIds.contains(id));
            }
            if (this.questUnlocks.containsKey(pool.getId())) {
                this.questUnlocks.get(pool.getId()).removeIf(id -> !questIds.contains(id));
            }
            if (!this.completedQuests.containsKey(pool.getId())) continue;
            this.completedQuests.get(pool.getId()).removeIf(id -> !questIds.contains(id));
        }
        this.dirty.set(true);
    }
}

