/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.event;

import gg.auroramc.quests.AuroraQuests;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BukkitEventBus
implements Listener {
    private final ConcurrentLinkedQueue<Listener> queue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<EventPriority, Set<Class<? extends Event>>> events = new ConcurrentHashMap<EventPriority, Set<Class<? extends Event>>>();
    private final ConcurrentMap<Class<? extends Event>, ConcurrentMap<EventPriority, CopyOnWriteArrayList<Consumer<? extends Event>>>> subscribers = new ConcurrentHashMap<Class<? extends Event>, ConcurrentMap<EventPriority, CopyOnWriteArrayList<Consumer<? extends Event>>>>();

    public <E extends Event> Subscription subscribe(Class<E> eventType, Consumer<E> handler, EventPriority priority, boolean ignoreCancelled, boolean handleSubclass) {
        this.events.compute(priority, (prio, set) -> {
            boolean wasAdded;
            if (set == null) {
                set = ConcurrentHashMap.newKeySet();
            }
            if (wasAdded = set.add(eventType)) {
                Bukkit.getPluginManager().registerEvent(eventType, (Listener)this, priority, (lst, evt) -> {
                    if (handleSubclass ? !eventType.isInstance(evt) : evt.getClass() != eventType) {
                        return;
                    }
                    this.dispatch(priority, evt);
                }, (Plugin)AuroraQuests.getInstance(), ignoreCancelled);
            }
            return set;
        });
        ConcurrentMap prMap = this.subscribers.computeIfAbsent(eventType, k -> new ConcurrentHashMap());
        CopyOnWriteArrayList handlers = prMap.computeIfAbsent(priority, k -> new CopyOnWriteArrayList());
        boolean handlerExists = handlers.contains(handler);
        if (!handlerExists) {
            handlers.add(handler);
        }
        return new Subscription(this, eventType, handler, priority);
    }

    private void dispatch(EventPriority priority, Event event) {
        ConcurrentMap prMap = (ConcurrentMap)this.subscribers.get(event.getClass());
        if (prMap == null) {
            return;
        }
        CopyOnWriteArrayList handlers = (CopyOnWriteArrayList)prMap.get(priority);
        if (handlers == null) {
            return;
        }
        for (Consumer h : handlers) {
            h.accept(event);
        }
    }

    public <E extends Event> void unsubscribe(Class<? extends Event> eventType, Consumer<E> handler, EventPriority priority) {
        ConcurrentMap prMap = (ConcurrentMap)this.subscribers.get(eventType);
        if (prMap == null) {
            return;
        }
        CopyOnWriteArrayList handlers = (CopyOnWriteArrayList)prMap.get(priority);
        if (handlers == null) {
            return;
        }
        handlers.remove(handler);
        if (handlers.isEmpty()) {
            prMap.remove(priority);
            if (prMap.isEmpty()) {
                this.subscribers.remove(eventType);
            }
        }
    }

    public static final class Subscription {
        private final BukkitEventBus bukkitEventBus;
        private final Class<? extends Event> eventType;
        private final Consumer<? extends Event> handler;
        private final EventPriority priority;

        public void unsubscribe() {
            this.bukkitEventBus.unsubscribe(this.eventType, this.handler, this.priority);
        }

        public Subscription(BukkitEventBus bukkitEventBus, Class<? extends Event> eventType, Consumer<? extends Event> handler, EventPriority priority) {
            this.bukkitEventBus = bukkitEventBus;
            this.eventType = eventType;
            this.handler = handler;
            this.priority = priority;
        }
    }
}

