/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.event.BukkitEventBus;
import gg.auroramc.quests.api.event.EventBus;
import gg.auroramc.quests.api.event.EventType;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.config.CommonMenuConfig;
import gg.auroramc.quests.hooks.HookManager;
import gg.auroramc.quests.hooks.worldguard.WorldGuardHook;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;

public abstract class Objective
extends EventBus {
    protected final ObjectiveDefinition definition;
    protected final Quest quest;
    protected final double target;
    protected final Profile.TaskDataWrapper data;
    protected boolean started = false;
    protected List<BukkitEventBus.Subscription> subscriptions;
    protected List<ScheduledTask> tasks;
    protected List<ObjectiveFilter> filters;

    public Objective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        this.quest = quest;
        this.definition = definition;
        this.target = definition.getArgs().getDouble("amount", 1.0);
        this.data = data;
        this.filters = this.getFilters();
        if (this.filters == null) {
            this.filters = new ArrayList<ObjectiveFilter>();
        }
    }

    protected <E extends Event> void onEvent(Class<E> event, Consumer<E> handler, EventPriority priority, boolean ignoreCancelled, boolean handleSubclass) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<BukkitEventBus.Subscription>();
        }
        this.subscriptions.add(AuroraQuests.getInstance().getBukkitEventBus().subscribe(event, e -> {
            if (e instanceof PlayerEvent) {
                PlayerEvent playerEvent = (PlayerEvent)e;
                if (playerEvent.getPlayer() == this.data.profile().getPlayer()) {
                    handler.accept(e);
                }
            } else {
                handler.accept(e);
            }
        }, priority, ignoreCancelled, handleSubclass));
    }

    protected <E extends Event> void onEvent(Class<E> event, Consumer<E> handler, EventPriority priority) {
        this.onEvent(event, handler, priority, true, false);
    }

    protected <E extends Event> void onEvent(Class<E> event, Consumer<E> handler, EventPriority priority, boolean ignoreCancelled) {
        this.onEvent(event, handler, priority, ignoreCancelled, false);
    }

    protected void syncInterval(Runnable runnable, int delay, int interval, boolean global) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<ScheduledTask>();
        }
        ScheduledTask task = global ? Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)AuroraQuests.getInstance(), t -> runnable.run(), (long)delay, (long)interval) : this.data.profile().getPlayer().getScheduler().runAtFixedRate((Plugin)AuroraQuests.getInstance(), t -> runnable.run(), null, (long)delay, (long)interval);
        this.tasks.add(task);
    }

    protected void asyncInterval(Runnable runnable, int delay, int interval) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<ScheduledTask>();
        }
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)AuroraQuests.getInstance(), t -> runnable.run(), (long)delay * 50L, (long)interval * 50L, TimeUnit.MILLISECONDS);
        this.tasks.add(task);
    }

    protected boolean passesFilters(ObjectiveMeta meta) {
        if (!meta.getPlayer().hasPermission("aurora.quests.use")) {
            return false;
        }
        if (HookManager.isEnabled(WorldGuardHook.class) && HookManager.getHook(WorldGuardHook.class).isBlocked(meta.getPlayer(), meta.getLocation())) {
            return false;
        }
        for (ObjectiveFilter filter : this.definition.getFilters()) {
            if (filter.filter(meta)) continue;
            return false;
        }
        for (ObjectiveFilter filter : this.filters) {
            if (filter.filter(meta)) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return this.definition.getId();
    }

    public void progress(double progress, ObjectiveMeta meta) {
        if (this.isCompleted()) {
            return;
        }
        if (this.passesFilters(meta)) {
            progress = this.applyMultipliers(progress, meta);
            this.data.progress(progress);
            this.publish(EventType.TASK_PROGRESS, this);
            if (this.isCompleted()) {
                this.publish(EventType.TASK_COMPLETED, this);
                this.dispose();
            }
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        if (this.isCompleted()) {
            return;
        }
        this.activate();
        this.started = true;
    }

    protected abstract void activate();

    public List<ObjectiveFilter> getFilters() {
        return new ArrayList<ObjectiveFilter>();
    }

    public double applyMultipliers(double progress, ObjectiveMeta meta) {
        return progress;
    }

    @Override
    public void dispose() {
        if (this.subscriptions != null) {
            for (BukkitEventBus.Subscription subscription : this.subscriptions) {
                subscription.unsubscribe();
            }
            this.subscriptions = null;
        }
        if (this.tasks != null) {
            for (ScheduledTask task : this.tasks) {
                task.cancel();
            }
            this.tasks = null;
        }
        this.started = false;
    }

    public void destroy() {
        super.dispose();
        this.dispose();
    }

    public double getProgress() {
        return this.data.isCompleted(this.target) ? this.target : this.data.getProgress();
    }

    public boolean isCompleted() {
        return this.data.isCompleted(this.target);
    }

    public String getType() {
        return this.definition.getTask();
    }

    public void complete(boolean silent) {
        this.data.setProgress(this.target);
        this.dispose();
        if (!silent) {
            this.publish(EventType.TASK_COMPLETED, this);
        }
    }

    public void setProgress(double progress) {
        this.data.setProgress(Math.min(progress, this.target));
        this.publish(EventType.TASK_PROGRESS, this);
        if (this.isCompleted()) {
            this.dispose();
            this.publish(EventType.TASK_COMPLETED, this);
        }
    }

    public void resetProgress() {
        this.data.resetProgress();
        this.publish(EventType.TASK_PROGRESS, this);
    }

    public String display() {
        CommonMenuConfig.TaskStatuses gc = AuroraQuests.getInstance().getConfigManager().getCommonMenuConfig().getTaskStatuses();
        double count = this.isCompleted() ? this.target : Math.min(this.data.getProgress(), this.target);
        return Placeholder.execute((String)this.definition.getDisplay(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{status}", (String)(this.isCompleted() ? gc.getCompleted() : gc.getNotCompleted())), Placeholder.of((String)"{current}", (String)AuroraAPI.formatNumber((double)count)), Placeholder.of((String)"{required}", (String)AuroraAPI.formatNumber((double)this.target))});
    }

    protected ObjectiveMeta meta() {
        return new ObjectiveMeta(this.data.profile().getPlayer(), this.data.profile().getPlayer().getLocation());
    }

    protected ObjectiveMeta meta(Location location) {
        return new ObjectiveMeta(this.data.profile().getPlayer(), location);
    }

    public ObjectiveDefinition getDefinition() {
        return this.definition;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public double getTarget() {
        return this.target;
    }

    public Profile.TaskDataWrapper getData() {
        return this.data;
    }

    public boolean isStarted() {
        return this.started;
    }
}

