/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ObjectiveMeta {
    private final Player player;
    private final Location location;
    private Map<String, Object> variables;

    public ObjectiveMeta(Player player, Location location) {
        this.player = player;
        this.location = location;
    }

    public ObjectiveMeta(Player player) {
        this(player, player.getLocation());
    }

    public <T> void setVariable(String name, T value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(name, value);
    }

    public <T> Optional<T> getVariable(String name, Class<T> type) {
        if (this.variables == null) {
            return Optional.empty();
        }
        Object raw = this.variables.get(name);
        if (type.isInstance(raw)) {
            return Optional.of(type.cast(raw));
        }
        return Optional.empty();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        return this.location;
    }
}

