/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective;

import gg.auroramc.quests.api.objective.Objective;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.StringTypeFilter;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public abstract class StringTypedObjective
extends Objective {
    private final Map<String, Double> multipliers = new HashMap<String, Double>();

    public StringTypedObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
        StringTypeFilter filter = new StringTypeFilter(new HashSet<String>(definition.getArgs().getStringList("types")), StringTypeFilter.Mode.parse(definition.getArgs().getString("mode", "whitelist")));
        this.filters.add(filter);
        ConfigurationSection multipliersSection = definition.getArgs().getConfigurationSection("multipliers");
        if (multipliersSection == null) {
            return;
        }
        for (String type : multipliersSection.getKeys(false)) {
            this.multipliers.put(type, multipliersSection.getDouble(type));
        }
    }

    @Override
    public double applyMultipliers(double progress, ObjectiveMeta meta) {
        Optional<String> variable = meta.getVariable("type", String.class);
        return variable.map(typeId -> progress * this.multipliers.getOrDefault(typeId, 1.0)).orElse(progress);
    }

    protected ObjectiveMeta meta(Location location, String type) {
        ObjectiveMeta meta = new ObjectiveMeta(this.data.profile().getPlayer(), location);
        meta.setVariable("type", type);
        return meta;
    }

    protected ObjectiveMeta meta(String type) {
        return this.meta(this.data.profile().getPlayer().getLocation(), type);
    }
}

