/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective;

import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.objective.Objective;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.TypeFilter;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;

public abstract class TypedObjective
extends Objective {
    private final Map<TypeId, Double> multipliers = new HashMap<TypeId, Double>();

    public TypedObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
        TypeFilter filter = new TypeFilter(definition.getArgs().getStringList("types").stream().map(TypeId::fromString).collect(Collectors.toSet()), TypeFilter.Mode.parse(definition.getArgs().getString("mode", "whitelist")));
        this.filters.add(filter);
        ConfigurationSection multipliersSection = definition.getArgs().getConfigurationSection("multipliers");
        if (multipliersSection == null) {
            return;
        }
        for (String type : multipliersSection.getKeys(false)) {
            this.multipliers.put(TypeId.fromString((String)type), multipliersSection.getDouble(type));
        }
    }

    @Override
    public double applyMultipliers(double progress, ObjectiveMeta meta) {
        Optional<TypeId> variable = meta.getVariable("type", TypeId.class);
        return variable.map(typeId -> progress * this.multipliers.getOrDefault(typeId, 1.0)).orElse(progress);
    }

    protected ObjectiveMeta meta(Location location, TypeId type) {
        ObjectiveMeta meta = new ObjectiveMeta(this.data.profile().getPlayer(), location);
        meta.setVariable("type", type);
        return meta;
    }

    protected ObjectiveMeta meta(Location location, String type) {
        ObjectiveMeta meta = new ObjectiveMeta(this.data.profile().getPlayer(), location);
        meta.setVariable("type", TypeId.fromString((String)type));
        return meta;
    }

    protected ObjectiveMeta meta(Location location, Material type) {
        ObjectiveMeta meta = new ObjectiveMeta(this.data.profile().getPlayer(), location);
        meta.setVariable("type", TypeId.from((Material)type));
        return meta;
    }

    protected ObjectiveMeta meta(Location location, EntityType type) {
        ObjectiveMeta meta = new ObjectiveMeta(this.data.profile().getPlayer(), location);
        meta.setVariable("type", TypeId.from((EntityType)type));
        return meta;
    }

    protected ObjectiveMeta meta(TypeId type) {
        return this.meta(this.data.profile().getPlayer().getLocation(), type);
    }

    protected ObjectiveMeta meta(String type) {
        return this.meta(this.data.profile().getPlayer().getLocation(), type);
    }

    protected ObjectiveMeta meta(Material type) {
        return this.meta(this.data.profile().getPlayer().getLocation(), type);
    }

    protected ObjectiveMeta meta(EntityType type) {
        return this.meta(this.data.profile().getPlayer().getLocation(), type);
    }
}

