/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective.filter;

import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;

public class DoubleFilter
implements ObjectiveFilter {
    private final String key;
    private final double value;

    @Override
    public boolean filter(ObjectiveMeta meta) {
        if (this.value == -1.0) {
            return true;
        }
        Optional<Double> current = meta.getVariable(this.key, Double.class);
        return current.map(s -> s.equals(this.value)).orElse(false);
    }

    public static DoubleFilter doubleFilter(ConfigurationSection args, String key) {
        return new DoubleFilter(key, args.getDouble(key, -1.0));
    }

    public static ObjectiveMeta with(ObjectiveMeta meta, String key, Double value) {
        meta.setVariable(key, value);
        return meta;
    }

    public DoubleFilter(String key, double value) {
        this.key = key;
        this.value = value;
    }
}

