/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective.filter;

import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;

public class RangeFilter
implements ObjectiveFilter {
    private final String key;
    private final Double concreteValue;
    private final Double minValue;
    private final Double maxValue;

    public RangeFilter(String key, Double minValue, Double maxValue) {
        this.key = key;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.concreteValue = null;
    }

    public RangeFilter(String key, Double concreteValue) {
        this.key = key;
        this.concreteValue = concreteValue;
        this.minValue = null;
        this.maxValue = null;
    }

    @Override
    public boolean filter(ObjectiveMeta meta) {
        Optional<Double> value = meta.getVariable(this.key, Double.class);
        if (value.isEmpty()) {
            return false;
        }
        if (this.concreteValue != null) {
            return value.get().equals(this.concreteValue);
        }
        double min = this.minValue != null ? this.minValue : 0.0;
        double max = this.maxValue != null ? this.maxValue : 2.147483647E9;
        return value.get() >= min && value.get() <= max;
    }

    public static RangeFilter rangeFilter(ConfigurationSection args, String key) {
        if (args.contains(key)) {
            return new RangeFilter(key, args.getDouble(key));
        }
        return new RangeFilter(key, args.getDouble("min-" + key), args.getDouble("max-" + key));
    }

    public static ObjectiveMeta with(ObjectiveMeta meta, String key, Double value) {
        meta.setVariable(key, value);
        return meta;
    }
}

