/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective.filter;

import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import java.util.Optional;
import java.util.Set;

public class StringTypeFilter
implements ObjectiveFilter {
    private Set<String> types;
    private Mode mode;

    @Override
    public boolean filter(ObjectiveMeta meta) {
        if (this.types == null || this.types.isEmpty()) {
            return true;
        }
        Optional<String> type = meta.getVariable("type", String.class);
        Optional<String> value = type.filter((? super T typeId) -> this.types.contains(typeId));
        if (this.mode == Mode.WHITELIST) {
            return value.isPresent();
        }
        return value.isEmpty();
    }

    public StringTypeFilter(Set<String> types, Mode mode) {
        this.types = types;
        this.mode = mode;
    }

    public static enum Mode {
        WHITELIST,
        BLACKLIST;


        public static Mode parse(String mode) {
            if (mode.equalsIgnoreCase("blacklist")) {
                return BLACKLIST;
            }
            return WHITELIST;
        }
    }
}

