/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.objective.filter;

import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import java.util.Optional;
import java.util.Set;

public class TypeFilter
implements ObjectiveFilter {
    private Set<TypeId> types;
    private Mode mode;

    @Override
    public boolean filter(ObjectiveMeta meta) {
        if (this.types == null || this.types.isEmpty()) {
            return true;
        }
        Optional<TypeId> type = meta.getVariable("type", TypeId.class);
        Optional<TypeId> value = type.filter((? super T typeId) -> this.types.contains(typeId));
        if (this.mode == Mode.WHITELIST) {
            return value.isPresent();
        }
        return value.isEmpty();
    }

    public TypeFilter(Set<TypeId> types, Mode mode) {
        this.types = types;
        this.mode = mode;
    }

    public static enum Mode {
        WHITELIST,
        BLACKLIST;


        public static Mode parse(String mode) {
            if (mode.equalsIgnoreCase("blacklist")) {
                return BLACKLIST;
            }
            return WHITELIST;
        }
    }
}

