/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.profile;

import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.data.QuestData;
import gg.auroramc.quests.api.questpool.Pool;
import gg.auroramc.quests.api.questpool.QuestPool;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Profile {
    private final AuroraUser user;
    private final Player player;
    private final Map<String, QuestPool> data = new LinkedHashMap<String, QuestPool>();

    public Profile(AuroraUser user) {
        this.user = user;
        this.player = user.getPlayer();
        this.reload(false);
    }

    public void reload(boolean destroy) {
        for (QuestPool questPool : this.data.values()) {
            if (destroy) {
                questPool.destroy();
                continue;
            }
            questPool.dispose();
        }
        this.data.clear();
        HashSet<QuestPool> rolledPools = new HashSet<QuestPool>();
        for (Pool pool : AuroraQuests.getInstance().getPoolManager().getPools()) {
            QuestPool questPool = new QuestPool(this, pool);
            this.data.put(pool.getId(), questPool);
            questPool.unlock(false);
            if (questPool.rollIfNecessary(false)) {
                rolledPools.add(questPool);
            }
            questPool.startQuests();
        }
        if (!rolledPools.isEmpty() && this.player.hasPlayedBefore()) {
            Placeholder placeholder = Placeholder.of((String)"{pool}", (String)String.join((CharSequence)", ", rolledPools.stream().map(QuestPool::getName).toList()));
            String msg = AuroraQuests.getInstance().getConfigManager().getMessageConfig((CommandSender)this.player).getReRolledTarget();
            msg = Placeholder.execute((String)msg, (Placeholder[])new Placeholder[]{placeholder});
            Chat.sendMessage((Player)this.player, (String)AuroraQuests.getInstance().getLocalizationProvider().fillVariables(this.player, msg, new Placeholder[]{placeholder}), (Placeholder[])new Placeholder[0]);
        }
        if (AuroraQuests.getInstance().getConfigManager().getConfig().getPurgeInvalidDataOnLogin().booleanValue()) {
            this.getData().purgeInvalidData(AuroraQuests.getInstance().getPoolManager().getPools());
        }
        Bukkit.getAsyncScheduler().runDelayed((Plugin)AuroraQuests.getInstance(), t -> AuroraQuests.getInstance().getPoolManager().getRewardAutoCorrector().correctRewards(this.player), 50L, TimeUnit.MILLISECONDS);
    }

    public Collection<QuestPool> getQuestPools() {
        return this.data.values();
    }

    public QuestPool getQuestPool(String id) {
        return this.data.get(id);
    }

    public TaskDataWrapper toTaskDataWrapper(String poolId, String questId, String taskId) {
        return new TaskDataWrapper(this, poolId, questId, taskId);
    }

    public QuestDataWrapper toQuestDataWrapper(String poolId, String questId) {
        return new QuestDataWrapper(this, poolId, questId);
    }

    public QuestData getData() {
        return (QuestData)this.user.getData(QuestData.class);
    }

    public void destroy() {
        for (QuestPool pool : this.data.values()) {
            pool.destroy();
        }
        this.data.clear();
    }

    public int hashCode() {
        return this.user.getUniqueId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Profile) {
            Profile profile = (Profile)obj;
            return this.user == profile.user;
        }
        return false;
    }

    public AuroraUser getUser() {
        return this.user;
    }

    public Player getPlayer() {
        return this.player;
    }

    public record TaskDataWrapper(Profile profile, String poolId, String questId, String taskId) {
        public boolean isCompleted(double target) {
            QuestData data = this.profile.getData();
            return data.hasCompletedQuest(this.poolId, this.questId) || data.getProgression(this.poolId, this.questId, this.taskId) >= target;
        }

        public double getProgress() {
            return this.profile.getData().getProgression(this.poolId, this.questId, this.taskId);
        }

        public void progress(double amount) {
            this.profile.getData().progress(this.poolId, this.questId, this.taskId, amount);
        }

        public void setProgress(double amount) {
            this.profile.getData().setProgress(this.poolId, this.questId, this.taskId, amount);
        }

        public void resetProgress() {
            this.profile.getData().resetTaskProgress(this.poolId, this.questId, this.taskId);
        }
    }

    public record QuestDataWrapper(Profile profile, String poolId, String questId) {
        public void complete() {
            QuestData data = this.profile.getData();
            data.completeQuest(this.poolId, this.questId);
        }

        public void reset() {
            this.profile.getData().resetQuestProgress(this.poolId, this.questId);
        }

        public boolean isCompleted() {
            return this.profile.getData().hasCompletedQuest(this.poolId, this.questId);
        }

        public boolean isUnlocked() {
            return this.profile.getData().isQuestStartUnlocked(this.poolId, this.questId);
        }

        public void unlock() {
            this.profile.getData().setQuestStartUnlock(this.poolId, this.questId);
        }

        public boolean hasCompletedQuest(String poolId, String questId) {
            return this.profile.getData().hasCompletedQuest(poolId, questId);
        }

        public TaskDataWrapper toTaskDataWrapper(String taskId) {
            return new TaskDataWrapper(this.profile, this.poolId, this.questId, taskId);
        }
    }
}

