/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.quest;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardExecutor;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.event.EventBus;
import gg.auroramc.quests.api.event.EventType;
import gg.auroramc.quests.api.event.QuestCompletedEvent;
import gg.auroramc.quests.api.factory.ObjectiveFactory;
import gg.auroramc.quests.api.objective.Objective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.QuestDefinition;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.config.quest.QuestConfig;
import gg.auroramc.quests.util.RewardUtil;
import gg.auroramc.quests.util.SoundUtil;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class Quest
extends EventBus {
    private final QuestDefinition definition;
    private final Profile.QuestDataWrapper data;
    private final List<Objective> objectives;
    private final QuestPool pool;
    private boolean started = false;

    public Quest(QuestPool pool, QuestDefinition definition, Profile.QuestDataWrapper data) {
        this.pool = pool;
        this.data = data;
        this.definition = definition;
        this.objectives = definition.getTasks().values().stream().map(d -> ObjectiveFactory.createObjective(this, d)).filter(Objects::nonNull).toList();
        for (Objective obj : this.objectives) {
            obj.subscribe(EventType.TASK_PROGRESS, objective -> {
                this.publish(EventType.TASK_PROGRESS, (Objective)objective);
                if (!objective.getDefinition().getOnProgress().isEmpty()) {
                    List<Placeholder> pl = List.of(Placeholder.of((String)"{player}", (String)data.profile().getPlayer().getName()), Placeholder.of((String)"{progress_raw}", (Number)objective.getProgress()), Placeholder.of((String)"{progress}", (String)AuroraAPI.formatNumber((double)objective.getProgress())), Placeholder.of((String)"{target_raw}", (Number)objective.getTarget()), Placeholder.of((String)"{target}", (String)AuroraAPI.formatNumber((double)objective.getTarget())), Placeholder.of((String)"{percent}", (String)AuroraAPI.formatNumber((double)(objective.getProgress() / objective.getTarget() * 100.0))));
                    for (String command : objective.getDefinition().getOnProgress()) {
                        CommandDispatcher.dispatch((Player)data.profile().getPlayer(), (String)command, pl);
                    }
                }
            });
            obj.subscribe(EventType.TASK_COMPLETED, objective -> {
                this.publish(EventType.TASK_COMPLETED, (Objective)objective);
                if (!objective.getDefinition().getOnComplete().isEmpty()) {
                    Placeholder pl = Placeholder.of((String)"{player}", (String)data.profile().getPlayer().getName());
                    for (String command : objective.getDefinition().getOnComplete()) {
                        CommandDispatcher.dispatch((Player)data.profile().getPlayer(), (String)command, (Placeholder[])new Placeholder[]{pl});
                    }
                }
                boolean completed = true;
                for (Objective obj2 : this.objectives) {
                    completed = completed && obj2.isCompleted();
                }
                if (completed) {
                    this.handleCompletion((Objective)objective);
                }
            });
        }
    }

    private void handleCompletion(@Nullable Objective trigger) {
        this.data.complete();
        Bukkit.getPluginManager().callEvent((Event)new QuestCompletedEvent(this.data.profile().getPlayer(), this.pool, this));
        this.reward();
        this.dispose();
        this.publish(EventType.QUEST_COMPLETED, trigger);
    }

    public boolean isUnlocked() {
        return !this.definition.getRequirements().hasRequirements() || this.data.isUnlocked();
    }

    public boolean canStart() {
        return this.definition.getRequirements().canStart(this.data);
    }

    public boolean start() {
        return this.start(false);
    }

    public boolean start(boolean force) {
        if (this.started) {
            return false;
        }
        if (this.pool.isGlobal() && !force && !this.definition.getRequirements().canStart(this.data)) {
            return false;
        }
        for (Objective obj : this.objectives) {
            obj.start();
        }
        if (this.pool.isGlobal()) {
            this.data.unlock();
        }
        this.started = true;
        return true;
    }

    public void unlock() {
        this.data.unlock();
    }

    public String getId() {
        return this.definition.getId();
    }

    public void reset() {
        for (Objective obj : this.objectives) {
            obj.resetProgress();
            if (!this.started) continue;
            obj.start();
        }
        this.data.reset();
    }

    public boolean isCompleted() {
        return this.data.isCompleted();
    }

    public void complete() {
        for (Objective obj : this.objectives) {
            obj.complete(true);
        }
        this.handleCompletion(null);
    }

    @Override
    public void dispose() {
        for (Objective obj : this.objectives) {
            obj.dispose();
        }
        this.started = false;
    }

    public void destroy() {
        super.dispose();
        for (Objective obj : this.objectives) {
            obj.destroy();
        }
        this.started = false;
    }

    public List<Placeholder<?>> getPlaceholders() {
        Config gc = AuroraQuests.getInstance().getConfigManager().getConfig();
        ArrayList placeholders = new ArrayList(9 + this.objectives.size() + this.definition.getRewards().size());
        placeholders.add(Placeholder.of((String)"{name}", (String)this.definition.getName()));
        placeholders.add(Placeholder.of((String)"{difficulty}", (String)gc.getDifficulties().get(this.definition.getDifficulty())));
        placeholders.add(Placeholder.of((String)"{difficulty_id}", (String)this.definition.getDifficulty()));
        placeholders.add(Placeholder.of((String)"{quest_id}", (String)this.definition.getId()));
        placeholders.add(Placeholder.of((String)"{quest}", (String)this.definition.getName()));
        placeholders.add(Placeholder.of((String)"{pool_id}", (String)this.pool.getId()));
        placeholders.add(Placeholder.of((String)"{pool}", (String)this.pool.getName()));
        placeholders.add(Placeholder.of((String)"{player}", (String)this.data.profile().getPlayer().getName()));
        placeholders.add(Placeholder.of((String)"{pool_level}", (Number)this.pool.getLevel()));
        for (Objective objective : this.objectives) {
            placeholders.add(Placeholder.of((String)("{task_" + objective.getId() + "}"), (String)objective.display()));
        }
        for (Map.Entry entry : this.definition.getRewards().entrySet()) {
            placeholders.add(Placeholder.of((String)("{reward_" + (String)entry.getKey() + "}"), (String)((Reward)entry.getValue()).getDisplay(this.data.profile().getPlayer(), placeholders)));
        }
        return placeholders;
    }

    private void reward() {
        Config gConfig = AuroraQuests.getInstance().getConfigManager().getConfig();
        List<Placeholder<?>> placeholders = this.getPlaceholders();
        Player player = this.data.profile().getPlayer();
        LinkedHashMap<String, Reward> rewards = this.definition.getRewards();
        if (this.definition.getQuestCompleteMessage() != null) {
            if (this.definition.getQuestCompleteMessage().getEnabled().booleanValue()) {
                lines = this.definition.getQuestCompleteMessage().getMessage();
                text = RewardUtil.fillRewardMessage(player, gConfig.getDisplayComponents().get("rewards"), lines, placeholders, rewards.values());
                int delay = this.definition.getQuestCompleteMessage().getDelay();
                if (delay > 0) {
                    player.getScheduler().runDelayed((Plugin)AuroraQuests.getInstance(), task -> player.sendMessage(text), null, (long)delay);
                } else {
                    player.sendMessage(text);
                }
            }
        } else if (gConfig.getQuestCompleteMessage().getEnabled().booleanValue()) {
            lines = gConfig.getQuestCompleteMessage().getMessage();
            text = RewardUtil.fillRewardMessage(player, gConfig.getDisplayComponents().get("rewards"), lines, placeholders, rewards.values());
            player.sendMessage(text);
        }
        if (this.definition.getQuestCompleteSound() != null) {
            if (this.definition.getQuestCompleteSound().getEnabled().booleanValue()) {
                sound = this.definition.getQuestCompleteSound();
                int delay = this.definition.getQuestCompleteSound().getDelay();
                if (delay > 0) {
                    player.getScheduler().runDelayed((Plugin)AuroraQuests.getInstance(), arg_0 -> Quest.lambda$reward$4(player, (QuestConfig.LevelUpSound)sound, arg_0), null, (long)delay);
                } else {
                    SoundUtil.playSound(player, ((QuestConfig.LevelUpSound)sound).getSound(), ((QuestConfig.LevelUpSound)sound).getVolume().floatValue(), ((QuestConfig.LevelUpSound)sound).getPitch().floatValue());
                }
            }
        } else if (gConfig.getQuestCompleteSound().getEnabled().booleanValue()) {
            sound = gConfig.getQuestCompleteSound();
            SoundUtil.playSound(player, ((Config.LevelUpSound)sound).getSound(), ((Config.LevelUpSound)sound).getVolume().floatValue(), ((Config.LevelUpSound)sound).getPitch().floatValue());
        }
        RewardExecutor.execute(rewards.values().stream().toList(), (Player)player, (long)1L, placeholders);
    }

    public QuestDefinition getDefinition() {
        return this.definition;
    }

    public Profile.QuestDataWrapper getData() {
        return this.data;
    }

    public List<Objective> getObjectives() {
        return this.objectives;
    }

    public QuestPool getPool() {
        return this.pool;
    }

    public boolean isStarted() {
        return this.started;
    }

    private static /* synthetic */ void lambda$reward$4(Player player, QuestConfig.LevelUpSound sound, ScheduledTask task) {
        SoundUtil.playSound(player, sound.getSound(), sound.getVolume().floatValue(), sound.getPitch().floatValue());
    }
}

