/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.quest;

import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.quest.QuestRequirement;
import gg.auroramc.quests.config.quest.QuestConfig;
import java.util.LinkedHashMap;
import java.util.List;

public class QuestDefinition {
    private final String id;
    private final String name;
    private final String difficulty;
    private final ItemConfig menuItem;
    private final List<String> lockedLore;
    private final List<String> completedLore;
    private final List<String> uncompletedLore;
    private final LinkedHashMap<String, ObjectiveDefinition> tasks;
    private final LinkedHashMap<String, Reward> rewards;
    private final QuestRequirement requirements;
    private final QuestConfig.LevelUpMessage questCompleteMessage;
    private final QuestConfig.LevelUpSound questCompleteSound;

    QuestDefinition(String id, String name, String difficulty, ItemConfig menuItem, List<String> lockedLore, List<String> completedLore, List<String> uncompletedLore, LinkedHashMap<String, ObjectiveDefinition> tasks, LinkedHashMap<String, Reward> rewards, QuestRequirement requirements, QuestConfig.LevelUpMessage questCompleteMessage, QuestConfig.LevelUpSound questCompleteSound) {
        this.id = id;
        this.name = name;
        this.difficulty = difficulty;
        this.menuItem = menuItem;
        this.lockedLore = lockedLore;
        this.completedLore = completedLore;
        this.uncompletedLore = uncompletedLore;
        this.tasks = tasks;
        this.rewards = rewards;
        this.requirements = requirements;
        this.questCompleteMessage = questCompleteMessage;
        this.questCompleteSound = questCompleteSound;
    }

    public static QuestDefinitionBuilder builder() {
        return new QuestDefinitionBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public ItemConfig getMenuItem() {
        return this.menuItem;
    }

    public List<String> getLockedLore() {
        return this.lockedLore;
    }

    public List<String> getCompletedLore() {
        return this.completedLore;
    }

    public List<String> getUncompletedLore() {
        return this.uncompletedLore;
    }

    public LinkedHashMap<String, ObjectiveDefinition> getTasks() {
        return this.tasks;
    }

    public LinkedHashMap<String, Reward> getRewards() {
        return this.rewards;
    }

    public QuestRequirement getRequirements() {
        return this.requirements;
    }

    public QuestConfig.LevelUpMessage getQuestCompleteMessage() {
        return this.questCompleteMessage;
    }

    public QuestConfig.LevelUpSound getQuestCompleteSound() {
        return this.questCompleteSound;
    }

    public static class QuestDefinitionBuilder {
        private String id;
        private String name;
        private String difficulty;
        private ItemConfig menuItem;
        private List<String> lockedLore;
        private List<String> completedLore;
        private List<String> uncompletedLore;
        private LinkedHashMap<String, ObjectiveDefinition> tasks;
        private LinkedHashMap<String, Reward> rewards;
        private QuestRequirement requirements;
        private QuestConfig.LevelUpMessage questCompleteMessage;
        private QuestConfig.LevelUpSound questCompleteSound;

        QuestDefinitionBuilder() {
        }

        public QuestDefinitionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public QuestDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public QuestDefinitionBuilder difficulty(String difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        public QuestDefinitionBuilder menuItem(ItemConfig menuItem) {
            this.menuItem = menuItem;
            return this;
        }

        public QuestDefinitionBuilder lockedLore(List<String> lockedLore) {
            this.lockedLore = lockedLore;
            return this;
        }

        public QuestDefinitionBuilder completedLore(List<String> completedLore) {
            this.completedLore = completedLore;
            return this;
        }

        public QuestDefinitionBuilder uncompletedLore(List<String> uncompletedLore) {
            this.uncompletedLore = uncompletedLore;
            return this;
        }

        public QuestDefinitionBuilder tasks(LinkedHashMap<String, ObjectiveDefinition> tasks) {
            this.tasks = tasks;
            return this;
        }

        public QuestDefinitionBuilder rewards(LinkedHashMap<String, Reward> rewards) {
            this.rewards = rewards;
            return this;
        }

        public QuestDefinitionBuilder requirements(QuestRequirement requirements) {
            this.requirements = requirements;
            return this;
        }

        public QuestDefinitionBuilder questCompleteMessage(QuestConfig.LevelUpMessage questCompleteMessage) {
            this.questCompleteMessage = questCompleteMessage;
            return this;
        }

        public QuestDefinitionBuilder questCompleteSound(QuestConfig.LevelUpSound questCompleteSound) {
            this.questCompleteSound = questCompleteSound;
            return this;
        }

        public QuestDefinition build() {
            return new QuestDefinition(this.id, this.name, this.difficulty, this.menuItem, this.lockedLore, this.completedLore, this.uncompletedLore, this.tasks, this.rewards, this.requirements, this.questCompleteMessage, this.questCompleteSound);
        }

        public String toString() {
            return "QuestDefinition.QuestDefinitionBuilder(id=" + this.id + ", name=" + this.name + ", difficulty=" + this.difficulty + ", menuItem=" + String.valueOf(this.menuItem) + ", lockedLore=" + String.valueOf(this.lockedLore) + ", completedLore=" + String.valueOf(this.completedLore) + ", uncompletedLore=" + String.valueOf(this.uncompletedLore) + ", tasks=" + String.valueOf(this.tasks) + ", rewards=" + String.valueOf(this.rewards) + ", requirements=" + String.valueOf(this.requirements) + ", questCompleteMessage=" + String.valueOf(this.questCompleteMessage) + ", questCompleteSound=" + String.valueOf(this.questCompleteSound) + ")";
        }
    }
}

