/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.quest;

import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.data.QuestData;
import gg.auroramc.quests.api.profile.Profile;
import java.util.List;
import org.bukkit.entity.Player;

public class QuestRequirement {
    private boolean alwaysShowInMenu;
    private boolean needsManualUnlock;
    private List<String> quests;
    private List<String> permissions;

    public boolean hasRequirements() {
        return this.quests != null && !this.quests.isEmpty() || this.permissions != null && !this.permissions.isEmpty() || this.needsManualUnlock;
    }

    public boolean canStart(Profile profile, String poolId) {
        QuestData data = profile.getData();
        if (this.needsManualUnlock && data.isPoolUnlocked(poolId)) {
            return false;
        }
        return this.meetsRequirements(profile, poolId);
    }

    public boolean canStart(Profile.QuestDataWrapper data) {
        if (this.needsManualUnlock && !data.isUnlocked()) {
            return false;
        }
        return this.meetsRequirements(data.profile(), data.poolId());
    }

    private boolean meetsRequirements(Profile profile, String poolId) {
        Player player = profile.getPlayer();
        QuestData data = profile.getData();
        if (this.quests != null && !this.quests.isEmpty()) {
            for (String questId : this.quests) {
                TypeId typeId = TypeId.fromString((String)questId);
                String pool = typeId.namespace().equals("minecraft") ? poolId : typeId.namespace();
                if (data.hasCompletedQuest(pool, typeId.id())) continue;
                return false;
            }
        }
        if (this.permissions != null && !this.permissions.isEmpty()) {
            for (String perm : this.permissions) {
                if (player.hasPermission(perm)) continue;
                return false;
            }
        }
        return true;
    }

    public QuestRequirement(boolean alwaysShowInMenu, boolean needsManualUnlock, List<String> quests, List<String> permissions) {
        this.alwaysShowInMenu = alwaysShowInMenu;
        this.needsManualUnlock = needsManualUnlock;
        this.quests = quests;
        this.permissions = permissions;
    }

    public boolean isAlwaysShowInMenu() {
        return this.alwaysShowInMenu;
    }

    public boolean isNeedsManualUnlock() {
        return this.needsManualUnlock;
    }

    public List<String> getQuests() {
        return this.quests;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }
}

