/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.questpool;

import gg.auroramc.aurora.api.levels.MatcherManager;
import gg.auroramc.aurora.api.reward.RewardFactory;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.questpool.PoolDefinition;
import gg.auroramc.quests.api.questpool.PoolType;
import gg.auroramc.quests.api.questpool.QuestRollerScheduler;
import java.time.Duration;

public class Pool {
    private final PoolDefinition definition;
    private MatcherManager matcherManager;
    private QuestRollerScheduler questRoller;

    public Pool(PoolDefinition definition, RewardFactory rewardFactory) {
        this.definition = definition;
        if (definition.getLeveling().getEnabled().booleanValue()) {
            this.matcherManager = new MatcherManager(rewardFactory);
            this.matcherManager.reload(definition.getLeveling().getLevelMatchers(), definition.getLeveling().getCustomLevels());
        }
        AuroraQuests.logger().debug("Loaded difficulties for pool " + definition.getId() + ": " + String.join((CharSequence)", ", definition.getDifficulties().keySet()));
    }

    public void start() {
        if (this.definition.getType() == PoolType.TIMED_RANDOM) {
            if (this.definition.isResetFrequencyValid()) {
                this.questRoller = new QuestRollerScheduler(this.definition);
            } else {
                AuroraQuests.logger().warning("Invalid reset frequency: " + this.definition.getResetFrequency() + " for pool " + this.definition.getId());
            }
        }
    }

    public String getId() {
        return this.definition.getId();
    }

    public Duration getDurationUntilNextRoll() {
        if (this.definition.getType() != PoolType.TIMED_RANDOM) {
            return Duration.ZERO;
        }
        return this.questRoller.getDurationUntilNextRoll();
    }

    public void dispose() {
        if (this.questRoller != null) {
            this.questRoller.shutdown();
        }
    }

    public PoolDefinition getDefinition() {
        return this.definition;
    }

    public MatcherManager getMatcherManager() {
        return this.matcherManager;
    }

    public QuestRollerScheduler getQuestRoller() {
        return this.questRoller;
    }
}

