/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.questpool;

import gg.auroramc.quests.api.quest.QuestDefinition;
import gg.auroramc.quests.api.quest.QuestRequirement;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.api.questpool.PoolType;
import java.util.LinkedHashMap;
import java.util.Map;

public class PoolDefinition {
    private final String id;
    private final PoolType type;
    private final String name;
    private final Map<String, Integer> difficulties;
    private final String resetFrequency;
    private final PoolConfig.PoolMenuItem menuItem;
    private final PoolConfig.PoolMenu menu;
    private final PoolConfig.Leveling leveling;
    private final QuestRequirement requirement;
    private final LinkedHashMap<String, QuestDefinition> quests;

    public boolean isResetFrequencyValid() {
        return this.resetFrequency != null && this.resetFrequency.split("\\s").length == 6;
    }

    PoolDefinition(String id, PoolType type, String name, Map<String, Integer> difficulties, String resetFrequency, PoolConfig.PoolMenuItem menuItem, PoolConfig.PoolMenu menu, PoolConfig.Leveling leveling, QuestRequirement requirement, LinkedHashMap<String, QuestDefinition> quests) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.difficulties = difficulties;
        this.resetFrequency = resetFrequency;
        this.menuItem = menuItem;
        this.menu = menu;
        this.leveling = leveling;
        this.requirement = requirement;
        this.quests = quests;
    }

    public static PoolDefinitionBuilder builder() {
        return new PoolDefinitionBuilder();
    }

    public String getId() {
        return this.id;
    }

    public PoolType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Integer> getDifficulties() {
        return this.difficulties;
    }

    public String getResetFrequency() {
        return this.resetFrequency;
    }

    public PoolConfig.PoolMenuItem getMenuItem() {
        return this.menuItem;
    }

    public PoolConfig.PoolMenu getMenu() {
        return this.menu;
    }

    public PoolConfig.Leveling getLeveling() {
        return this.leveling;
    }

    public QuestRequirement getRequirement() {
        return this.requirement;
    }

    public LinkedHashMap<String, QuestDefinition> getQuests() {
        return this.quests;
    }

    public static class PoolDefinitionBuilder {
        private String id;
        private PoolType type;
        private String name;
        private Map<String, Integer> difficulties;
        private String resetFrequency;
        private PoolConfig.PoolMenuItem menuItem;
        private PoolConfig.PoolMenu menu;
        private PoolConfig.Leveling leveling;
        private QuestRequirement requirement;
        private LinkedHashMap<String, QuestDefinition> quests;

        PoolDefinitionBuilder() {
        }

        public PoolDefinitionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PoolDefinitionBuilder type(PoolType type) {
            this.type = type;
            return this;
        }

        public PoolDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PoolDefinitionBuilder difficulties(Map<String, Integer> difficulties) {
            this.difficulties = difficulties;
            return this;
        }

        public PoolDefinitionBuilder resetFrequency(String resetFrequency) {
            this.resetFrequency = resetFrequency;
            return this;
        }

        public PoolDefinitionBuilder menuItem(PoolConfig.PoolMenuItem menuItem) {
            this.menuItem = menuItem;
            return this;
        }

        public PoolDefinitionBuilder menu(PoolConfig.PoolMenu menu) {
            this.menu = menu;
            return this;
        }

        public PoolDefinitionBuilder leveling(PoolConfig.Leveling leveling) {
            this.leveling = leveling;
            return this;
        }

        public PoolDefinitionBuilder requirement(QuestRequirement requirement) {
            this.requirement = requirement;
            return this;
        }

        public PoolDefinitionBuilder quests(LinkedHashMap<String, QuestDefinition> quests) {
            this.quests = quests;
            return this;
        }

        public PoolDefinition build() {
            return new PoolDefinition(this.id, this.type, this.name, this.difficulties, this.resetFrequency, this.menuItem, this.menu, this.leveling, this.requirement, this.quests);
        }

        public String toString() {
            return "PoolDefinition.PoolDefinitionBuilder(id=" + this.id + ", type=" + String.valueOf((Object)this.type) + ", name=" + this.name + ", difficulties=" + String.valueOf(this.difficulties) + ", resetFrequency=" + this.resetFrequency + ", menuItem=" + String.valueOf(this.menuItem) + ", menu=" + String.valueOf(this.menu) + ", leveling=" + String.valueOf(this.leveling) + ", requirement=" + String.valueOf(this.requirement) + ", quests=" + String.valueOf(this.quests) + ")";
        }
    }
}

