/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.questpool;

import gg.auroramc.aurora.api.reward.CommandReward;
import gg.auroramc.aurora.api.reward.ItemReward;
import gg.auroramc.aurora.api.reward.MoneyReward;
import gg.auroramc.aurora.api.reward.RewardAutoCorrector;
import gg.auroramc.aurora.api.reward.RewardFactory;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.event.QuestsLoadedEvent;
import gg.auroramc.quests.api.questpool.Pool;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class PoolManager {
    private final RewardFactory rewardFactory = new RewardFactory();
    private final RewardAutoCorrector rewardAutoCorrector = new RewardAutoCorrector();
    private final Map<String, Pool> registry = new HashMap<String, Pool>();

    public PoolManager() {
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"command"), CommandReward.class);
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"money"), MoneyReward.class);
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"item"), ItemReward.class);
        try {
            StdSchedulerFactory.getDefaultScheduler().start();
        }
        catch (SchedulerException e) {
            AuroraQuests.logger().severe("Failed to start scheduler: " + e.getMessage());
        }
    }

    public void reload(List<Pool> pools) {
        for (Pool pool : this.registry.values()) {
            pool.dispose();
        }
        this.registry.clear();
        for (Pool pool : pools) {
            this.registry.put(pool.getId(), pool);
            pool.start();
        }
        Bukkit.getPluginManager().callEvent((Event)new QuestsLoadedEvent());
    }

    public Pool getPool(String id) {
        return this.registry.get(id);
    }

    public Set<String> getPoolIds() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }

    public Collection<Pool> getPools() {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    public RewardFactory getRewardFactory() {
        return this.rewardFactory;
    }

    public RewardAutoCorrector getRewardAutoCorrector() {
        return this.rewardAutoCorrector;
    }
}

