/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.questpool;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.RewardExecutor;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.data.PoolRollData;
import gg.auroramc.quests.api.data.QuestData;
import gg.auroramc.quests.api.event.EventType;
import gg.auroramc.quests.api.event.QuestPoolLevelUpEvent;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.quest.QuestDefinition;
import gg.auroramc.quests.api.questpool.Pool;
import gg.auroramc.quests.api.questpool.PoolDefinition;
import gg.auroramc.quests.api.questpool.PoolType;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.util.RewardUtil;
import gg.auroramc.quests.util.RomanNumber;
import gg.auroramc.quests.util.SoundUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class QuestPool {
    private final Pool pool;
    private final Profile profile;
    private final Map<String, Quest> quests = new LinkedHashMap<String, Quest>();

    public QuestPool(Profile profile, Pool pool) {
        this.profile = profile;
        this.pool = pool;
        for (QuestDefinition questDef : pool.getDefinition().getQuests().values()) {
            Quest quest = new Quest(this, questDef, profile.toQuestDataWrapper(this.getId(), questDef.getId()));
            this.quests.put(questDef.getId(), quest);
            quest.subscribe(EventType.QUEST_COMPLETED, t -> {
                int currentLevel = this.getLevel();
                profile.getData().incrementCompletedCount(this.getId());
                if (!this.isGlobal() || AuroraQuests.getInstance().getConfigManager().getConfig().getLeaderboards().getIncludeGlobal().booleanValue()) {
                    AuroraAPI.getLeaderboards().updateUser(profile.getUser(), new String[]{"quests_" + this.getId()});
                }
                int newLevel = this.getLevel();
                if (this.hasLeveling() && newLevel > currentLevel) {
                    this.reward(newLevel);
                    Bukkit.getPluginManager().callEvent((Event)new QuestPoolLevelUpEvent(profile.getPlayer(), this));
                }
            });
        }
    }

    public void dispose() {
        for (Quest quest : this.quests.values()) {
            quest.dispose();
        }
    }

    public void destroy() {
        for (Quest quest : this.quests.values()) {
            quest.destroy();
        }
    }

    public String getId() {
        return this.pool.getId();
    }

    public String getName() {
        return this.pool.getDefinition().getName();
    }

    public PoolDefinition getDefinition() {
        return this.pool.getDefinition();
    }

    public List<Quest> getActiveQuests() {
        if (this.isTimedRandom()) {
            return this.profile.getData().getPoolRollData(this.getId()).quests().stream().map(this.quests::get).filter(Objects::nonNull).toList();
        }
        return this.quests.values().stream().filter(Quest::isUnlocked).toList();
    }

    public boolean isRolledQuest(Quest quest) {
        return this.profile.getData().getPoolRollData(this.getId()).quests().contains(quest.getId());
    }

    public List<Quest> getNotCompletedQuests() {
        if (!this.isTimedRandom()) {
            return this.quests.values().stream().filter(q -> !q.isCompleted()).toList();
        }
        return this.getActiveQuests().stream().filter(q -> !q.isCompleted()).toList();
    }

    public Quest getQuest(String id) {
        return this.quests.get(id);
    }

    public Collection<Quest> getQuests() {
        return this.quests.values();
    }

    public void resetAllQuestProgress() {
        for (Quest quest : this.quests.values()) {
            quest.reset();
            if (this.isGlobal()) {
                quest.start(false);
                continue;
            }
            if (!this.isRolledQuest(quest)) continue;
            quest.start(false);
        }
    }

    public boolean hasLeveling() {
        return this.pool.getDefinition().getLeveling().getEnabled();
    }

    public boolean isUnlocked() {
        return this.pool.getDefinition().getRequirement().canStart(this.profile, this.getId()) || this.profile.getData().isPoolUnlocked(this.getId());
    }

    public boolean unlock(boolean force) {
        if (this.isUnlocked()) {
            return false;
        }
        if (!force && !this.pool.getDefinition().getRequirement().canStart(this.profile, this.getId())) {
            return false;
        }
        this.profile.getData().unlockPool(this.getId());
        String msg = AuroraQuests.getInstance().getConfigManager().getMessageConfig((CommandSender)this.profile.getPlayer()).getPoolUnlocked();
        Chat.sendMessage((Player)this.profile.getPlayer(), (String)msg, (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)this.pool.getDefinition().getName())});
        return true;
    }

    public void startQuests() {
        if (!this.isUnlocked()) {
            return;
        }
        if (this.isTimedRandom()) {
            for (Quest quest : this.getActiveQuests()) {
                quest.start();
            }
        } else {
            for (Quest quest : this.quests.values()) {
                quest.start(false);
            }
        }
    }

    public int getLevel() {
        if (this.pool.getDefinition().getLeveling().getEnabled().booleanValue()) {
            long completed = this.profile.getData().getCompletedCount(this.getId());
            List<Integer> requirements = this.pool.getDefinition().getLeveling().getRequirements();
            for (int i = requirements.size() - 1; i >= 0; --i) {
                if (completed < (long)requirements.get(i).intValue()) continue;
                return i + 1;
            }
            return 0;
        }
        return 0;
    }

    public List<Placeholder<?>> getLevelPlaceholders(int level) {
        int prevLevel = Math.max(0, level - 1);
        return List.of(Placeholder.of((String)"{player}", (String)this.profile.getPlayer().getName()), Placeholder.of((String)"{level_raw}", (Number)level), Placeholder.of((String)"{level}", (String)AuroraAPI.formatNumber((long)level)), Placeholder.of((String)"{level_roman}", (String)RomanNumber.toRoman(level)), Placeholder.of((String)"{prev_level_raw}", (Number)prevLevel), Placeholder.of((String)"{prev_level}", (String)AuroraAPI.formatNumber((long)prevLevel)), Placeholder.of((String)"{prev_level_roman}", (String)RomanNumber.toRoman(prevLevel)), Placeholder.of((String)"{pool}", (String)this.pool.getDefinition().getName()), Placeholder.of((String)"{pool_id}", (String)this.getId()));
    }

    public long getCompletedQuestCount() {
        return this.profile.getData().getCompletedCount(this.getId());
    }

    public boolean isGlobal() {
        return !this.isTimedRandom();
    }

    public boolean isTimedRandom() {
        return this.pool.getDefinition().getType() == PoolType.TIMED_RANDOM;
    }

    public void reRollQuests(boolean sendNotification) {
        Object quests;
        if (this.isGlobal()) {
            return;
        }
        if (!this.isUnlocked()) {
            return;
        }
        PoolDefinition definition = this.pool.getDefinition();
        HashMap pickedQuests = new HashMap();
        Map<String, Integer> difficulties = definition.getDifficulties();
        List<Quest> questsToSelectFrom = this.quests.values().stream().filter(q -> difficulties.containsKey(q.getDefinition().getDifficulty()) && q.canStart()).toList();
        AuroraQuests.logger().debug("Picking quests from pool " + definition.getId() + " for player " + this.profile.getPlayer().getName() + " with " + questsToSelectFrom.size() + " quests");
        HashMap<String, List> pickableQuests = new HashMap<String, List>();
        for (Quest quest : questsToSelectFrom) {
            if (quest.getDefinition().getDifficulty() == null) continue;
            pickableQuests.computeIfAbsent(quest.getDefinition().getDifficulty(), k -> new ArrayList()).add(quest);
        }
        for (String string : pickableQuests.keySet()) {
            quests = (List)pickableQuests.get(string);
            Collections.shuffle(quests);
        }
        for (Map.Entry entry : difficulties.entrySet()) {
            quests = (List)pickableQuests.get(entry.getKey());
            if (quests == null || quests.isEmpty()) {
                pickedQuests.put((String)entry.getKey(), Collections.emptyList());
                continue;
            }
            pickedQuests.put((String)entry.getKey(), quests.subList(0, Math.min((Integer)entry.getValue(), quests.size())));
        }
        QuestData data = this.profile.getData();
        List<String> list = pickedQuests.values().stream().flatMap(Collection::stream).map(Quest::getId).toList();
        if (data.getPoolRollData(this.getId()) != null) {
            for (Quest quest : this.getActiveQuests()) {
                quest.dispose();
            }
        }
        data.setRolledQuests(this.getId(), list);
        for (Quest quest : this.getActiveQuests()) {
            quest.start();
        }
        AuroraQuests.logger().debug("Rolled quests for player " + this.profile.getPlayer().getName() + " in pool " + definition.getId() + ": " + String.join((CharSequence)", ", list));
        if (sendNotification) {
            String msg = AuroraQuests.getInstance().getConfigManager().getMessageConfig((CommandSender)this.profile.getPlayer()).getReRolledTarget();
            Placeholder placeholder = Placeholder.of((String)"{pool}", (String)definition.getName());
            msg = Placeholder.execute((String)msg, (Placeholder[])new Placeholder[]{placeholder});
            Chat.sendMessage((Player)this.profile.getPlayer(), (String)AuroraQuests.getInstance().getLocalizationProvider().fillVariables(this.profile.getPlayer(), msg, new Placeholder[]{placeholder}), (Placeholder[])new Placeholder[0]);
        }
    }

    public boolean rollIfNecessary(boolean sendNotification) {
        AuroraQuests.logger().debug("Checking if player " + this.profile.getPlayer().getName() + " needs to reroll quests for pool " + this.pool.getDefinition().getId());
        if (!this.isTimedRandom()) {
            return false;
        }
        if (!this.pool.getQuestRoller().isValid()) {
            return false;
        }
        if (!this.isUnlocked()) {
            return false;
        }
        AuroraQuests.logger().debug("Pool is timed random and quest roller is valid");
        try {
            boolean hasInvalidQuests;
            QuestData data = this.profile.getData();
            PoolRollData rollData = data.getPoolRollData(this.getId());
            boolean bl = hasInvalidQuests = rollData != null && rollData.quests().stream().anyMatch(q -> !this.pool.getDefinition().getQuests().containsKey(q));
            if (rollData == null || this.pool.getQuestRoller().shouldReroll(rollData.timestamp()) || hasInvalidQuests) {
                this.reRollQuests(sendNotification);
                return true;
            }
        }
        catch (Exception e) {
            AuroraQuests.logger().severe("Failed to reroll quests for player " + this.profile.getPlayer().getName() + " in pool " + this.pool.getDefinition().getId() + ": " + e.getMessage());
        }
        return false;
    }

    public Duration getDurationUntilNextRoll() {
        return this.pool.getDurationUntilNextRoll();
    }

    private void reward(int level) {
        Config mc = AuroraQuests.getInstance().getConfigManager().getConfig();
        List rewards = this.pool.getMatcherManager().getBestMatcher(level).computeRewards(level);
        List<Placeholder<?>> placeholders = this.getLevelPlaceholders(level);
        Player player = this.profile.getPlayer();
        if (mc.getLevelUpMessage().getEnabled().booleanValue()) {
            List<String> lines = mc.getLevelUpMessage().getMessage();
            Component text = RewardUtil.fillRewardMessage(player, mc.getDisplayComponents().get("rewards"), lines, placeholders, rewards);
            player.sendMessage(text);
        }
        if (mc.getLevelUpSound().getEnabled().booleanValue()) {
            Config.LevelUpSound sound = mc.getLevelUpSound();
            SoundUtil.playSound(player, sound.getSound(), sound.getVolume().floatValue(), sound.getPitch().floatValue());
        }
        RewardExecutor.execute((List)rewards, (Player)player, (long)level, placeholders);
    }

    public Pool getPool() {
        return this.pool;
    }

    public Profile getProfile() {
        return this.profile;
    }
}

