/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.api.questpool;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.questpool.Pool;
import gg.auroramc.quests.api.questpool.PoolDefinition;
import gg.auroramc.quests.api.questpool.QuestPool;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuestRollerScheduler {
    private final PoolDefinition pool;
    private Scheduler scheduler;
    private JobDetail job;
    private Trigger trigger;
    private ExecutionTime executionTime;
    private volatile boolean valid = false;
    private final AtomicReference<ZonedDateTime> nextExecutionTime = new AtomicReference<Object>(null);

    public QuestRollerScheduler(PoolDefinition pool) {
        this.pool = pool;
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            String cronExpression = pool.getResetFrequency();
            this.job = JobBuilder.newJob(QuestRollJob.class).withIdentity(pool.getId() + "-QuestRollJob").usingJobData("poolId", pool.getId()).build();
            this.trigger = TriggerBuilder.newTrigger().withIdentity(pool.getId() + "-QuestRollTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser parser = new CronParser(definition);
            Cron cron = parser.parse(cronExpression);
            this.executionTime = ExecutionTime.forCron((Cron)cron);
            this.scheduler.scheduleJob(this.job, this.trigger);
            this.valid = true;
            AuroraQuests.logger().info("Scheduled quest reroll job for pool " + pool.getId() + " with next time: " + new SimpleDateFormat().format(this.getNextRollDate()));
        }
        catch (SchedulerException e) {
            AuroraQuests.logger().severe("Failed to start scheduler: " + e.getMessage());
        }
    }

    public void resetNextExecutionTime() {
        this.nextExecutionTime.set(null);
    }

    public Date getNextRollDate() {
        return this.trigger.getNextFireTime();
    }

    public boolean shouldReroll(Long timestamp) {
        if (timestamp == null) {
            return true;
        }
        ZonedDateTime lastRerollTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        ZonedDateTime now = ZonedDateTime.now();
        Optional lastExecution = this.executionTime.lastExecution(now);
        if (lastExecution.isPresent()) {
            ZonedDateTime previousExecutionTime = (ZonedDateTime)lastExecution.get();
            return lastRerollTime.isBefore(previousExecutionTime);
        }
        return true;
    }

    public Duration getDurationUntilNextRoll() {
        ZonedDateTime next = this.nextExecutionTime.get();
        if (next != null) {
            ZonedDateTime now = ZonedDateTime.now();
            Duration duration = Duration.between(now, next);
            if (duration.isNegative()) {
                return Duration.ZERO;
            }
            return duration;
        }
        ZonedDateTime now = ZonedDateTime.now();
        Optional nextExecution = this.executionTime.nextExecution(now);
        if (nextExecution.isPresent()) {
            ZonedDateTime nextExecutionTime = (ZonedDateTime)nextExecution.get();
            this.nextExecutionTime.set(nextExecutionTime);
            Duration duration = Duration.between(now, nextExecutionTime);
            if (duration.isNegative()) {
                return Duration.ZERO;
            }
            return duration;
        }
        return Duration.ZERO;
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        if (this.job == null) {
            return;
        }
        if (this.trigger == null) {
            return;
        }
        try {
            this.scheduler.deleteJob(this.job.getKey());
        }
        catch (SchedulerException e) {
            AuroraQuests.logger().severe("Failed to remove job from quest poll (" + this.pool.getId() + ") scheduler: " + e.getMessage());
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public static class QuestRollJob
    implements Job {
        public void execute(JobExecutionContext context) {
            Pool pool = AuroraQuests.getInstance().getPoolManager().getPool(context.getJobDetail().getJobDataMap().getString("poolId"));
            AuroraQuests.logger().debug("Executing quest reroll job for pool " + pool.getId());
            Bukkit.getAsyncScheduler().runDelayed((Plugin)AuroraQuests.getInstance(), task -> {
                pool.getQuestRoller().resetNextExecutionTime();
                ArrayList<Profile> players = new ArrayList<Profile>(AuroraQuests.getInstance().getProfileManager().getProfiles());
                for (Profile player : players) {
                    QuestPool questPool = player.getQuestPool(pool.getId());
                    questPool.reRollQuests(true);
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }
}

