/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.command;

import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.command.QuestsCommand;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.config.MessageConfig;
import gg.auroramc.quests.libs.acf.MessageKeys;
import gg.auroramc.quests.libs.acf.MinecraftMessageKeys;
import gg.auroramc.quests.libs.acf.PaperCommandManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final AuroraQuests plugin;
    private final PaperCommandManager commandManager;
    private final LegacyComponentSerializer serializer = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacyAmpersand().toBuilder()).hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private boolean hasSetup = false;

    public CommandManager(AuroraQuests plugin) {
        this.commandManager = new PaperCommandManager((Plugin)plugin);
        this.plugin = plugin;
    }

    private void setupCommands() {
        if (!this.hasSetup) {
            this.commandManager.getLocales().setDefaultLocale(Locale.ENGLISH);
            this.commandManager.usePerIssuerLocale(false);
            Config.CommandAliasConfig aliases = this.plugin.getConfigManager().getConfig().getCommandAliases();
            Map<String, PoolConfig> pools = this.plugin.getConfigManager().getQuestPools();
            this.commandManager.getCommandCompletions().registerCompletion("pools", c -> pools.values().stream().map(PoolConfig::getId).collect(Collectors.toList()));
            this.commandManager.getCommandCompletions().registerCompletion("quests", c -> pools.values().stream().filter(pool -> c.getContextValue(String.class).equals(pool.getId())).flatMap(pool -> pool.getQuests().keySet().stream()).collect(Collectors.toList()));
            this.commandManager.getCommandReplacements().addReplacement("questsAlias", this.a(aliases.getQuests()));
        }
        MessageConfig msg = this.plugin.getConfigManager().getMessageConfig(null);
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND_OFFLINE, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.IS_NOT_A_VALID_NAME, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.COULD_NOT_FIND_PLAYER, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.PERMISSION_DENIED, this.m(msg.getNoPermission()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.PERMISSION_DENIED_PARAMETER, this.m(msg.getNoPermission()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.INVALID_SYNTAX, this.m(msg.getInvalidSyntax()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.MUST_BE_A_NUMBER, this.m(msg.getMustBeNumber()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_PERFORMING_COMMAND, this.m(msg.getCommandError()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_GENERIC_LOGGED, this.m(msg.getCommandError()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.NOT_ALLOWED_ON_CONSOLE, this.m(msg.getPlayerOnlyCommand()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.UNKNOWN_COMMAND, this.m(msg.getUnknownCommand()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_PREFIX, this.m(msg.getErrorPrefix()));
        if (!this.hasSetup) {
            this.commandManager.registerCommand(new QuestsCommand(this.plugin));
            this.hasSetup = true;
        }
    }

    public void reload() {
        this.setupCommands();
    }

    private String a(List<String> aliases) {
        return String.join((CharSequence)"|", aliases);
    }

    private String m(String msg) {
        return this.serializer.serialize(Text.component((String)Chat.translateToMM((String)msg), (Placeholder[])new Placeholder[0]));
    }

    public void unregisterCommands() {
        this.commandManager.unregisterCommands();
    }
}

