/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.command;

import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.libs.acf.BaseCommand;
import gg.auroramc.quests.libs.acf.annotation.CommandAlias;
import gg.auroramc.quests.libs.acf.annotation.CommandCompletion;
import gg.auroramc.quests.libs.acf.annotation.CommandPermission;
import gg.auroramc.quests.libs.acf.annotation.Default;
import gg.auroramc.quests.libs.acf.annotation.Description;
import gg.auroramc.quests.libs.acf.annotation.Flags;
import gg.auroramc.quests.libs.acf.annotation.Subcommand;
import gg.auroramc.quests.menu.MainMenu;
import gg.auroramc.quests.menu.PoolMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%questsAlias")
public class QuestsCommand
extends BaseCommand {
    private final AuroraQuests plugin;

    public QuestsCommand(AuroraQuests plugin) {
        this.plugin = plugin;
    }

    @Default
    @Description(value="Opens the quests menu")
    @CommandPermission(value="aurora.quests.use")
    public void onMenu(Player player) {
        Profile profile = this.plugin.getProfileManager().getProfile(player);
        if (profile == null) {
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig((CommandSender)player).getDataNotLoadedYetSelf(), (Placeholder[])new Placeholder[0]);
            return;
        }
        new MainMenu(profile).open();
    }

    @Subcommand(value="reload")
    @Description(value="Reloads the plugin configs and applies reward auto correctors to players")
    @CommandPermission(value="aurora.quests.admin.reload")
    public void onReload(CommandSender sender) {
        this.plugin.reload();
        Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getReloaded(), (Placeholder[])new Placeholder[0]);
    }

    @Subcommand(value="open")
    @Description(value="Opens the quest menu for another player in a specific pool")
    @CommandCompletion(value="@players @pools|none|all true|false")
    @CommandPermission(value="aurora.quests.admin.open")
    public void onOpenMenu(CommandSender sender, @Flags(value="other") Player target, @Default(value="none") String poolId, @Default(value="false") Boolean silent) {
        Profile profile = this.plugin.getProfileManager().getProfile(target);
        if (profile == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getDataNotLoadedYet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{target}", (String)target.getName())});
            return;
        }
        if (poolId.equals("none") || poolId.equals("all")) {
            new MainMenu(profile).open();
        } else {
            QuestPool pool = profile.getQuestPool(poolId);
            if (pool == null) {
                Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getPoolNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)poolId)});
                return;
            }
            if (pool.isUnlocked()) {
                new PoolMenu(profile, pool).open();
                if (!silent.booleanValue()) {
                    Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getMenuOpened(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName())});
                }
            }
        }
    }

    @Subcommand(value="reroll")
    @Description(value="Rerolls quests for another player in a specific pool")
    @CommandCompletion(value="@players @pools|none|all true|false")
    @CommandPermission(value="aurora.quests.admin.reroll")
    public void onReroll(CommandSender sender, @Flags(value="other") Player target, @Default(value="all") String poolId, @Default(value="false") Boolean silent) {
        Profile profile = this.plugin.getProfileManager().getProfile(target);
        if (profile == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getDataNotLoadedYet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{target}", (String)target.getName())});
            return;
        }
        if (poolId.equals("none") || poolId.equals("all")) {
            profile.getQuestPools().forEach(pool -> pool.reRollQuests(silent == false));
        } else {
            QuestPool pool2 = profile.getQuestPool(poolId);
            if (pool2 != null) {
                if (!pool2.isUnlocked()) {
                    return;
                }
                pool2.reRollQuests(silent == false);
                if (!silent.booleanValue()) {
                    Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getReRolledSource(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{pool}", (String)pool2.getDefinition().getName())});
                }
            } else {
                Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getPoolNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)poolId)});
            }
        }
    }

    @Subcommand(value="unlock")
    @Description(value="Unlocks quest for player")
    @CommandCompletion(value="@players @pools @quests true|false")
    @CommandPermission(value="aurora.quests.admin.unlock")
    public void onQuestUnlock(CommandSender sender, @Flags(value="other") Player target, String poolId, String questId, @Default(value="false") Boolean silent) {
        Profile profile = this.plugin.getProfileManager().getProfile(target);
        if (profile == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getDataNotLoadedYet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{target}", (String)target.getName())});
            return;
        }
        QuestPool pool = profile.getQuestPool(poolId);
        if (pool == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getPoolNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)poolId)});
            return;
        }
        Quest quest = pool.getQuest(questId);
        if (quest == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)pool.getId()), Placeholder.of((String)"{quest}", (String)questId)});
            return;
        }
        if (!quest.isUnlocked()) {
            quest.start(true);
            if (!silent.booleanValue()) {
                Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestUnlocked(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{quest}", (String)questId)});
            }
        } else {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestAlreadyUnlocked(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{quest}", (String)questId)});
        }
    }

    @Subcommand(value="complete")
    @Description(value="Completes a quest for a player")
    @CommandCompletion(value="@players @pools @quests true|false")
    @CommandPermission(value="aurora.quests.admin.complete")
    public void onQuestComplete(CommandSender sender, @Flags(value="other") Player target, String poolId, String questId, @Default(value="false") Boolean silent) {
        Profile profile = this.plugin.getProfileManager().getProfile(target);
        if (profile == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getDataNotLoadedYet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{target}", (String)target.getName())});
            return;
        }
        QuestPool pool = profile.getQuestPool(poolId);
        if (pool == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getPoolNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)poolId)});
            return;
        }
        Quest quest = pool.getQuest(questId);
        if (quest == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)pool.getId()), Placeholder.of((String)"{quest}", (String)questId)});
            return;
        }
        if (!quest.isCompleted()) {
            quest.complete();
            if (!silent.booleanValue()) {
                Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestCompleted(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{quest}", (String)questId)});
            }
        } else {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestAlreadyCompleted(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{quest}", (String)questId)});
        }
    }

    @Subcommand(value="reset")
    @Description(value="Reset quest progress a player")
    @CommandCompletion(value="@players @pools @quests|all true|false")
    @CommandPermission(value="aurora.quests.admin.reset")
    public void onQuestReset(CommandSender sender, @Flags(value="other") Player target, String poolId, @Default(value="all") String questId, @Default(value="false") Boolean silent) {
        Profile profile = this.plugin.getProfileManager().getProfile(target);
        if (profile == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getDataNotLoadedYet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{target}", (String)target.getName())});
            return;
        }
        QuestPool pool = profile.getQuestPool(poolId);
        if (pool == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getPoolNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)poolId)});
            return;
        }
        Quest quest = pool.getQuest(questId);
        if (questId.equals("all")) {
            pool.resetAllQuestProgress();
            if (!silent.booleanValue()) {
                Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestReset(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{quest}", (String)"all")});
            }
            return;
        }
        if (quest == null) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestNotFound(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{pool}", (String)pool.getId()), Placeholder.of((String)"{quest}", (String)questId)});
            return;
        }
        quest.reset();
        if (pool.isGlobal()) {
            quest.start(false);
        } else if (pool.isRolledQuest(quest)) {
            quest.start(false);
        }
        if (!silent.booleanValue()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig(sender).getQuestReset(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)target.getName()), Placeholder.of((String)"{quest}", (String)questId)});
        }
    }
}

