/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.decorators.IgnoreField;
import gg.auroramc.quests.AuroraQuests;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config
extends AuroraConfig {
    private Boolean debug = false;
    private Boolean purgeInvalidDataOnLogin = false;
    private String language = "en";
    private Boolean perPlayerLocale = false;
    private Map<String, String> difficulties;
    private Boolean preventCreativeMode = false;
    private LeaderboardConfig leaderboards;
    private Map<String, DisplayComponent> displayComponents;
    private LevelUpSound levelUpSound;
    private LevelUpMessage levelUpMessage;
    private LevelUpSound questCompleteSound;
    private LevelUpMessage questCompleteMessage;
    private CommandAliasConfig commandAliases;
    private List<String> sortOrder;
    private UnlockTaskConfig unlockTask = new UnlockTaskConfig();
    @IgnoreField
    private Map<String, Integer> sortOderMap;

    public void load() {
        super.load();
        HashMap<String, Integer> difficultyOrder = new HashMap<String, Integer>();
        for (int i = 0; i < this.sortOrder.size(); ++i) {
            difficultyOrder.put(this.sortOrder.get(i), i);
        }
        this.sortOderMap = difficultyOrder;
    }

    public Config(AuroraQuests plugin) {
        super(Config.getFile(plugin));
    }

    public static File getFile(AuroraQuests plugin) {
        return new File(plugin.getDataFolder(), "config.yml");
    }

    public static void saveDefault(AuroraQuests plugin) {
        if (!Config.getFile(plugin).exists()) {
            plugin.saveResource("config.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("purge-invalid-data-on-login", (Object)false);
            yaml.setComments("purge-invalid-data-on-login", List.of("Only enable this if you are heavily modifying your quest pools/quests data in production (WHICH YOU SHOULDN'T)"));
            yaml.set("unlock-task.enabled", (Object)false);
            yaml.set("unlock-task.interval", (Object)5);
            yaml.setComments("unlock-task", List.of("Timer to try to unlock global quests and quest pools if for some reason the event driven method doesn't work"));
            yaml.setComments("unlock-task.interval", List.of("Interval in seconds"));
            for (String key : List.of("weeks", "days", "hours", "minutes", "seconds")) {
                yaml.set("timer-format.short-format.plural." + key, (Object)("{value}" + key.charAt(0)));
                yaml.set("timer-format.short-format.singular." + key, (Object)("{value}" + key.charAt(0)));
                yaml.set("timer-format.long-format.plural." + key, (Object)("{value} " + key));
                yaml.set("timer-format.long-format.singular." + key, (Object)("{value} " + key.substring(0, key.length() - 1)));
            }
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("level-up-sound.sound", (Object)"entity.player.levelup");
            yaml.set("quest-complete-sound.sound", (Object)"entity.player.levelup");
            yaml.set("config-version", (Object)2);
        }, yaml -> {
            yaml.set("timer-format", null);
            yaml.set("config-version", (Object)3);
        }, yaml -> {
            yaml.set("per-player-locale", (Object)false);
            yaml.set("config-version", (Object)4);
        });
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public Boolean getPurgeInvalidDataOnLogin() {
        return this.purgeInvalidDataOnLogin;
    }

    public String getLanguage() {
        return this.language;
    }

    public Boolean getPerPlayerLocale() {
        return this.perPlayerLocale;
    }

    public Map<String, String> getDifficulties() {
        return this.difficulties;
    }

    public Boolean getPreventCreativeMode() {
        return this.preventCreativeMode;
    }

    public LeaderboardConfig getLeaderboards() {
        return this.leaderboards;
    }

    public Map<String, DisplayComponent> getDisplayComponents() {
        return this.displayComponents;
    }

    public LevelUpSound getLevelUpSound() {
        return this.levelUpSound;
    }

    public LevelUpMessage getLevelUpMessage() {
        return this.levelUpMessage;
    }

    public LevelUpSound getQuestCompleteSound() {
        return this.questCompleteSound;
    }

    public LevelUpMessage getQuestCompleteMessage() {
        return this.questCompleteMessage;
    }

    public CommandAliasConfig getCommandAliases() {
        return this.commandAliases;
    }

    public List<String> getSortOrder() {
        return this.sortOrder;
    }

    public UnlockTaskConfig getUnlockTask() {
        return this.unlockTask;
    }

    public Map<String, Integer> getSortOderMap() {
        return this.sortOderMap;
    }

    public static final class UnlockTaskConfig {
        private Boolean enabled = false;
        private Integer interval = 5;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Integer getInterval() {
            return this.interval;
        }
    }

    public static final class LeaderboardConfig {
        private Integer cacheSize = 10;
        private Integer minCompleted = 3;
        private Boolean includeGlobal = false;

        public Integer getCacheSize() {
            return this.cacheSize;
        }

        public Integer getMinCompleted() {
            return this.minCompleted;
        }

        public Boolean getIncludeGlobal() {
            return this.includeGlobal;
        }
    }

    public static final class LevelUpSound {
        private Boolean enabled;
        private String sound;
        private Float volume;
        private Float pitch;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getSound() {
            return this.sound;
        }

        public Float getVolume() {
            return this.volume;
        }

        public Float getPitch() {
            return this.pitch;
        }
    }

    public static final class LevelUpMessage {
        private Boolean enabled;
        private List<String> message;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public List<String> getMessage() {
            return this.message;
        }
    }

    public static final class CommandAliasConfig {
        private List<String> quests = List.of("quests");

        public List<String> getQuests() {
            return this.quests;
        }
    }

    public static final class DisplayComponent {
        private String title;
        private String line;

        public String getTitle() {
            return this.title;
        }

        public String getLine() {
            return this.line;
        }
    }
}

