/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.config;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.config.CommonMenuConfig;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.config.MainMenuConfig;
import gg.auroramc.quests.config.MessageConfig;
import gg.auroramc.quests.config.quest.QuestConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ConfigManager {
    private final AuroraQuests plugin;
    private Config config;
    private final Map<Locale, MessageConfig> messageConfigs = new HashMap<Locale, MessageConfig>();
    private MainMenuConfig mainMenuConfig;
    private CommonMenuConfig commonMenuConfig;
    private final Map<String, PoolConfig> questPools = Maps.newConcurrentMap();
    private Locale defaultLocale;

    public ConfigManager(AuroraQuests plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        boolean saveDefaultQuests = !Config.getFile(this.plugin).exists();
        Config.saveDefault(this.plugin);
        this.config = new Config(this.plugin);
        this.config.load();
        this.defaultLocale = Locale.forLanguageTag(this.config.getLanguage());
        for (Locale locale : Aurora.getLanguageProvider().getSupportedLocales()) {
            MessageConfig.saveDefault(this.plugin, locale.getLanguage());
            MessageConfig messageConfig = new MessageConfig(this.plugin, locale.getLanguage());
            messageConfig.load();
            this.messageConfigs.put(locale, messageConfig);
        }
        CommonMenuConfig.saveDefault(this.plugin);
        this.commonMenuConfig = new CommonMenuConfig(this.plugin);
        this.commonMenuConfig.load();
        MainMenuConfig.saveDefault(this.plugin);
        this.mainMenuConfig = new MainMenuConfig(this.plugin);
        this.mainMenuConfig.load();
        if (saveDefaultQuests) {
            this.saveDefaultQuests();
        }
        this.reloadQuests();
    }

    public MessageConfig getMessageConfig(CommandSender sender) {
        if (this.config.getPerPlayerLocale().booleanValue()) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                Locale locale = Aurora.getLanguageProvider().getPlayerLocale(player);
                return this.messageConfigs.get(locale);
            }
            return this.messageConfigs.get(Aurora.getLanguageProvider().getFallbackLocale());
        }
        return this.messageConfigs.get(this.defaultLocale);
    }

    public void saveDefaultQuests() {
        Path jarPath = Path.of(((Object)((Object)this.plugin)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        Path dataFolder = this.plugin.getDataFolder().toPath();
        try (JarFile jar = new JarFile(jarPath.toFile());){
            jar.stream().filter(entry -> entry.getName().startsWith("quest_pools/") && entry.getName().endsWith(".yml")).forEach(entry -> {
                Path outFile = dataFolder.resolve(entry.getName());
                Path parentDir = outFile.getParent();
                if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(parentDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try (InputStream is = jar.getInputStream((ZipEntry)entry);){
                    Files.copy(is, outFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void reloadQuests() {
        this.questPools.clear();
        Path questsDir = this.plugin.getDataFolder().toPath().resolve("quest_pools");
        if (!Files.exists(questsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> directories = Files.walk(questsDir, 1, new FileVisitOption[0]);){
            directories.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> !p.equals(questsDir)).forEach(dir -> {
                File poolFile = new File(dir.toFile(), "config.yml");
                if (!poolFile.exists()) {
                    return;
                }
                PoolConfig poolConfig = new PoolConfig(poolFile);
                poolConfig.load();
                poolConfig.setId(dir.toFile().getName());
                Path qDir = Paths.get(dir.toFile().getAbsolutePath(), "quests");
                if (!Files.exists(qDir, new LinkOption[0])) {
                    return;
                }
                try (Stream<Path> paths = Files.walk(qDir, 5, new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".yml")).forEach(path -> {
                        String relativePath = qDir.relativize((Path)path).toString();
                        String questId = relativePath.replace(File.separator, "/").replace(".yml", "");
                        QuestConfig questConfig = new QuestConfig(path.toFile());
                        questConfig.load();
                        questConfig.setPoolConfig(poolConfig);
                        questConfig.setId(questId);
                        if (poolConfig.getQuests().containsKey(questConfig.getId())) {
                            AuroraQuests.logger().severe("Duplicate quest id: " + questId + " in pool: " + poolConfig.getId() + " skipping... File names most be unique inside the pools quests folder.");
                        } else {
                            poolConfig.getQuests().put(questConfig.getId(), questConfig);
                            AuroraQuests.logger().debug("Loaded quest: " + questId + " from pool: " + poolConfig.getId());
                        }
                    });
                }
                catch (IOException e) {
                    AuroraQuests.logger().severe("Failed to load quests for pool: " + poolConfig.getId() + " error: " + e.getMessage());
                }
                this.questPools.put(dir.toFile().getName(), poolConfig);
            });
        }
        catch (IOException e) {
            AuroraQuests.logger().severe("Failed to load quests: " + e.getMessage());
        }
    }

    public AuroraQuests getPlugin() {
        return this.plugin;
    }

    public Config getConfig() {
        return this.config;
    }

    public Map<Locale, MessageConfig> getMessageConfigs() {
        return this.messageConfigs;
    }

    public MainMenuConfig getMainMenuConfig() {
        return this.mainMenuConfig;
    }

    public CommonMenuConfig getCommonMenuConfig() {
        return this.commonMenuConfig;
    }

    public Map<String, PoolConfig> getQuestPools() {
        return this.questPools;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }
}

