/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.quests.AuroraQuests;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageConfig
extends AuroraConfig {
    private String prefix = "";
    private String reloaded = "&aReloaded configuration!";
    private String dataNotLoadedYet = "&cData for this player hasn't loaded yet, try again later!";
    private String dataNotLoadedYetSelf = "&cYour data isn't loaded yet, please try again later!";
    private String playerOnlyCommand = "&cThis command can only be executed by a player!";
    private String noPermission = "&cYou don't have permission to execute this command!";
    private String invalidSyntax = "&cInvalid command syntax!";
    private String mustBeNumber = "&cArgument must be a number!";
    private String playerNotFound = "&cPlayer not found!";
    private String commandError = "&cAn error occurred while executing this command!";
    private String menuOpened = "&aOpened collection menu for {player}";
    private String reRolledTarget = "&aYour quests for {pool} have been re-rolled!";
    private String reRolledSource = "&aQuests for {player} for pool {pool} have been re-rolled!";
    private String globalQuestUnlocked = "&aYou have unlocked the {quest} quest in {pool}!";
    private String poolNotFound = "&cThere isn't any quest line with this id: {pool}!";
    private String poolUnlocked = "&aYou have unlocked a new quest pool: {pool}!";
    private String unknownCommand = "&cUnknown Command, please type /help";
    private String questNotFound = "&cThere isn't any quest with id {quest} in pool {pool}!";
    private String questUnlocked = "&aQuest {quest} unlocked for {player}.";
    private String questCompleted = "&aQuest {quest} marked completed for {player}.";
    private String questReset = "&aQuest {quest} reset for {player}.";
    private String questAlreadyUnlocked = "&cPlayer {player} has already unlocked quest {quest}.";
    private String questAlreadyCompleted = "&cPlayer {player} has already completed quest {quest}.";
    private String errorPrefix = "&cError: {message}";
    private TimerFormatConfig timerFormat = new TimerFormatConfig();
    private ConfigurationSection custom;

    public MessageConfig(AuroraQuests plugin, String language) {
        super(MessageConfig.getFile(plugin, language));
    }

    public Map<String, String> toFlatMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.getRawConfig().getKeys(false)) {
            if (key.equals("custom")) {
                for (String customKey : this.getRawConfig().getConfigurationSection("custom").getKeys(true)) {
                    map.put(customKey, this.getRawConfig().getString("custom." + customKey));
                }
                continue;
            }
            map.put(key, this.getRawConfig().getString(key));
        }
        return map;
    }

    private static File getFile(AuroraQuests plugin, String language) {
        return new File(plugin.getDataFolder(), "messages_" + language + ".yml");
    }

    public static void saveDefault(AuroraQuests plugin, String language) {
        if (!MessageConfig.getFile(plugin, language).exists()) {
            try {
                plugin.saveResource("messages_" + language + ".yml", false);
            }
            catch (Exception e) {
                AuroraQuests.logger().warning("Internal message file for language: " + language + " not found! Creating a new one from english...");
                File file = MessageConfig.getFile(plugin, language);
                try (InputStream in = plugin.getResource("messages_en.yml");){
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
                catch (IOException ex) {
                    AuroraQuests.logger().severe("Failed to create message file for language: " + language);
                    ex.printStackTrace();
                }
            }
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("quest-not-found", (Object)"&cThere isn't any quest with id {quest} in pool {pool}!");
            yaml.set("quest-unlocked", (Object)"&aQuest {quest} unlocked for {player}.");
            yaml.set("quest-already-unlocked", (Object)"&cPlayer {player} has already unlocked quest {quest}.");
            yaml.set("error-prefix", (Object)"&cError: {message}");
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("quest-completed", (Object)"&aQuest {quest} marked completed for {player}.");
            yaml.set("quest-already-completed", (Object)"&cPlayer {player} has already completed quest {quest}.");
            yaml.set("config-version", (Object)2);
        }, yaml -> {
            yaml.set("quest-reset", (Object)"&aQuest {quest} reset for {player}.");
            yaml.set("config-version", (Object)3);
        }, yaml -> {
            yaml.set("prefix", (Object)"");
            ConfigurationSection timer = yaml.createSection("timer-format");
            ConfigurationSection shortFormat = timer.createSection("short-format");
            ConfigurationSection shortPlural = shortFormat.createSection("plural");
            shortPlural.set("weeks", (Object)"{value}w");
            shortPlural.set("days", (Object)"{value}d");
            shortPlural.set("hours", (Object)"{value}h");
            shortPlural.set("minutes", (Object)"{value}m");
            shortPlural.set("seconds", (Object)"{value}s");
            ConfigurationSection shortSingular = shortFormat.createSection("singular");
            shortSingular.set("weeks", (Object)"{value}w");
            shortSingular.set("days", (Object)"{value}d");
            shortSingular.set("hours", (Object)"{value}h");
            shortSingular.set("minutes", (Object)"{value}m");
            shortSingular.set("seconds", (Object)"{value}s");
            ConfigurationSection longFormat = timer.createSection("long-format");
            ConfigurationSection longPlural = longFormat.createSection("plural");
            longPlural.set("weeks", (Object)"{value} weeks");
            longPlural.set("days", (Object)"{value} days");
            longPlural.set("hours", (Object)"{value} hours");
            longPlural.set("minutes", (Object)"{value} minutes");
            longPlural.set("seconds", (Object)"{value} seconds");
            ConfigurationSection longSingular = longFormat.createSection("singular");
            longSingular.set("weeks", (Object)"{value} week");
            longSingular.set("days", (Object)"{value} day");
            longSingular.set("hours", (Object)"{value} hour");
            longSingular.set("minutes", (Object)"{value} minute");
            longSingular.set("seconds", (Object)"{value} second");
            yaml.set("timer-format", (Object)timer);
            yaml.set("custom", (Object)yaml.createSection("custom"));
            yaml.set("config-version", (Object)4);
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getReloaded() {
        return this.reloaded;
    }

    public String getDataNotLoadedYet() {
        return this.dataNotLoadedYet;
    }

    public String getDataNotLoadedYetSelf() {
        return this.dataNotLoadedYetSelf;
    }

    public String getPlayerOnlyCommand() {
        return this.playerOnlyCommand;
    }

    public String getNoPermission() {
        return this.noPermission;
    }

    public String getInvalidSyntax() {
        return this.invalidSyntax;
    }

    public String getMustBeNumber() {
        return this.mustBeNumber;
    }

    public String getPlayerNotFound() {
        return this.playerNotFound;
    }

    public String getCommandError() {
        return this.commandError;
    }

    public String getMenuOpened() {
        return this.menuOpened;
    }

    public String getReRolledTarget() {
        return this.reRolledTarget;
    }

    public String getReRolledSource() {
        return this.reRolledSource;
    }

    public String getGlobalQuestUnlocked() {
        return this.globalQuestUnlocked;
    }

    public String getPoolNotFound() {
        return this.poolNotFound;
    }

    public String getPoolUnlocked() {
        return this.poolUnlocked;
    }

    public String getUnknownCommand() {
        return this.unknownCommand;
    }

    public String getQuestNotFound() {
        return this.questNotFound;
    }

    public String getQuestUnlocked() {
        return this.questUnlocked;
    }

    public String getQuestCompleted() {
        return this.questCompleted;
    }

    public String getQuestReset() {
        return this.questReset;
    }

    public String getQuestAlreadyUnlocked() {
        return this.questAlreadyUnlocked;
    }

    public String getQuestAlreadyCompleted() {
        return this.questAlreadyCompleted;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public TimerFormatConfig getTimerFormat() {
        return this.timerFormat;
    }

    public ConfigurationSection getCustom() {
        return this.custom;
    }

    public static final class TimerFormatConfig {
        private DurationFormatConfig shortFormat = new DurationFormatConfig();
        private DurationFormatConfig longFormat = new DurationFormatConfig();

        public DurationFormatConfig getShortFormat() {
            return this.shortFormat;
        }

        public DurationFormatConfig getLongFormat() {
            return this.longFormat;
        }
    }

    public static final class DurationConfig {
        private String weeks = "{value}w";
        private String days = "{value}d";
        private String hours = "{value}h";
        private String minutes = "{value}m";
        private String seconds = "{value}s";

        public String getWeeks() {
            return this.weeks;
        }

        public String getDays() {
            return this.days;
        }

        public String getHours() {
            return this.hours;
        }

        public String getMinutes() {
            return this.minutes;
        }

        public String getSeconds() {
            return this.seconds;
        }
    }

    public static final class DurationFormatConfig {
        private DurationConfig plural = new DurationConfig();
        private DurationConfig singular = new DurationConfig();

        public DurationConfig getPlural() {
            return this.plural;
        }

        public DurationConfig getSingular() {
            return this.singular;
        }
    }
}

