/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks;

import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.hooks.Hook;
import gg.auroramc.quests.hooks.Hooks;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HookManager {
    private static final Map<Class<? extends Hook>, Hook> hooks = new HashMap<Class<? extends Hook>, Hook>();

    public static void enableHooks(AuroraQuests plugin) {
        for (Hook hook : hooks.values()) {
            try {
                hook.hook(plugin);
                if (!(hook instanceof Listener)) continue;
                Bukkit.getPluginManager().registerEvents((Listener)hook, (Plugin)plugin);
            }
            catch (Exception e) {
                AuroraQuests.logger().warning("Failed to enable hook " + hook.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    public static void loadHooks(AuroraQuests plugin) {
        for (Hooks hook : Hooks.values()) {
            try {
                if (!hook.canHook()) continue;
                Hook instance = hook.getClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance.hookAtStartUp(plugin);
                hooks.put(hook.getClazz(), instance);
            }
            catch (Exception e) {
                AuroraQuests.logger().warning("Failed to hook " + String.join((CharSequence)", ", hook.getPlugins()) + ": " + e.getMessage());
            }
        }
    }

    public static <T extends Hook> T getHook(Class<T> clazz) {
        return (T)((Hook)clazz.cast(hooks.get(clazz)));
    }

    public static <T extends Hook> boolean isEnabled(Class<T> clazz) {
        return hooks.get(clazz) != null;
    }
}

