/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.auraskills;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.user.SkillsUser;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.hooks.auraskills.AuraSkillsStatReward;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AuraSkillsCorrector
implements RewardCorrector {
    private final Set<UUID> toLoad = Sets.newConcurrentHashSet();

    public void correctRewards(Player player) {
        if (AuraSkillsApi.get().getUser(player.getUniqueId()).isLoaded()) {
            this.correctRewardsWhenLoaded(player, true);
        } else {
            this.toLoad.add(player.getUniqueId());
        }
    }

    public void correctRewardsWhenLoaded(Player player, boolean force) {
        if (!force && !this.toLoad.contains(player.getUniqueId())) {
            return;
        }
        this.toLoad.remove(player.getUniqueId());
        Profile profile = AuroraQuests.getInstance().getProfileManager().getProfile(player);
        HashMap statMap = Maps.newHashMap();
        for (Stat stat : AuraSkillsApi.get().getGlobalRegistry().getStats()) {
            statMap.put(stat, 0.0);
        }
        for (QuestPool pool : profile.getQuestPools()) {
            if (pool.isGlobal()) {
                for (Quest quest : pool.getQuests()) {
                    if (!quest.isCompleted()) continue;
                    for (Reward reward : quest.getDefinition().getRewards().values()) {
                        if (!(reward instanceof AuraSkillsStatReward)) continue;
                        AuraSkillsStatReward statReward = (AuraSkillsStatReward)reward;
                        statMap.merge(statReward.getStat(), statReward.getValue(quest.getPlaceholders()), Double::sum);
                    }
                }
            }
            if (!pool.hasLeveling()) continue;
            int level = pool.getLevel();
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = pool.getPool().getMatcherManager().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = pool.getLevelPlaceholders(i);
                for (Reward reward : matcher.computeRewards(i)) {
                    if (!(reward instanceof AuraSkillsStatReward)) continue;
                    AuraSkillsStatReward statReward = (AuraSkillsStatReward)reward;
                    statMap.merge(statReward.getStat(), statReward.getValue(placeholders), Double::sum);
                }
            }
        }
        player.getScheduler().run((Plugin)AuroraQuests.getInstance(), task -> {
            SkillsUser user = AuraSkillsApi.get().getUser(player.getUniqueId());
            if (!user.isLoaded()) {
                return;
            }
            for (Map.Entry entry : statMap.entrySet()) {
                String statKey = AuraSkillsStatReward.getAURA_SKILLS_STAT() + ((Stat)entry.getKey()).getId().toString();
                StatModifier oldModifier = user.getStatModifier(statKey);
                if (oldModifier == null) {
                    if (!((Double)entry.getValue() > 0.0)) continue;
                    user.addStatModifier(new StatModifier(statKey, (Stat)entry.getKey(), ((Double)entry.getValue()).doubleValue()));
                    continue;
                }
                if ((Double)entry.getValue() <= 0.0) {
                    user.removeStatModifier(statKey);
                    continue;
                }
                if (((Double)entry.getValue()).doubleValue() == oldModifier.value()) continue;
                user.addStatModifier(new StatModifier(statKey, (Stat)entry.getKey(), ((Double)entry.getValue()).doubleValue()));
            }
        }, null);
    }
}

