/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.auraskills;

import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.event.objective.PlayerLootEvent;
import gg.auroramc.quests.hooks.auraskills.AuraSkillsHook;
import gg.auroramc.quests.objective.FarmingObjective;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class AuraSkillsListener
implements Listener {
    private final AuraSkillsHook hook;

    public AuraSkillsListener(AuraSkillsHook hook) {
        this.hook = hook;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExtraDrop(LootDropEvent e) {
        ItemStack item = e.getItem();
        if (item.getType() == Material.AIR) {
            return;
        }
        TypeId typeId = AuroraAPI.getItemManager().resolveId(item);
        if (FarmingObjective.specialCrops.contains(item.getType()) && typeId.namespace().equals("minecraft")) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerLootEvent(e.getPlayer(), typeId, item.getAmount(), PlayerLootEvent.Source.FARM));
            return;
        }
        switch (e.getCause()) {
            case FARMING_LUCK: 
            case FARMING_OTHER_LOOT: {
                Bukkit.getPluginManager().callEvent((Event)new PlayerLootEvent(e.getPlayer(), typeId, item.getAmount(), PlayerLootEvent.Source.FARM));
                break;
            }
            case FORAGING_LUCK: 
            case FORAGING_OTHER_LOOT: 
            case MINING_LUCK: 
            case EXCAVATION_OTHER_LOOT: 
            case LUCKY_SPADES: 
            case MINING_OTHER_LOOT: 
            case EXCAVATION_LUCK: 
            case METAL_DETECTOR: {
                Bukkit.getPluginManager().callEvent((Event)new PlayerLootEvent(e.getPlayer(), typeId, item.getAmount(), PlayerLootEvent.Source.BLOCK));
                break;
            }
            case MOB_LOOT_TABLE: {
                Bukkit.getPluginManager().callEvent((Event)new PlayerLootEvent(e.getPlayer(), typeId, item.getAmount(), PlayerLootEvent.Source.ENTITY));
                break;
            }
            case LUCK_DOUBLE_DROP: {
                Bukkit.getPluginManager().callEvent((Event)new PlayerLootEvent(e.getPlayer(), typeId, item.getAmount(), PlayerLootEvent.Source.ALL));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUserLoad(UserLoadEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getUser().getUuid());
        if (player == null) {
            return;
        }
        CompletableFuture.runAsync(() -> this.hook.getCorrector().correctRewardsWhenLoaded(player, false));
    }
}

