/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.economyshopgui;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.event.objective.PlayerEarnFromSellEvent;
import gg.auroramc.quests.api.event.objective.PlayerPurchaseItemEvent;
import gg.auroramc.quests.api.event.objective.PlayerSellItemEvent;
import gg.auroramc.quests.api.event.objective.PlayerSpendOnPurchaseEvent;
import java.util.Map;
import java.util.Set;
import me.gypopo.economyshopgui.api.events.PostTransactionEvent;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.Transaction;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class EconomyShopGUIListener
implements Listener {
    private final Set<Transaction.Result> successResults = Set.of(Transaction.Result.SUCCESS, Transaction.Result.SUCCESS_COMMANDS_EXECUTED, Transaction.Result.NOT_ALL_ITEMS_ADDED);
    private final Set<Transaction.Type> buyTypes = Set.of(Transaction.Type.BUY_SCREEN, Transaction.Type.BUY_STACKS_SCREEN, Transaction.Type.QUICK_BUY, Transaction.Type.SHOPSTAND_BUY_SCREEN);
    private final Set<Transaction.Type> sellTypes = Set.of(Transaction.Type.SELL_GUI_SCREEN, Transaction.Type.SELL_SCREEN, Transaction.Type.SELL_ALL_SCREEN, Transaction.Type.SELL_ALL_COMMAND, Transaction.Type.QUICK_SELL, Transaction.Type.AUTO_SELL_CHEST, Transaction.Type.SHOPSTAND_SELL_SCREEN);

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTransaction(PostTransactionEvent e) {
        if (!this.successResults.contains(e.getTransactionResult())) {
            return;
        }
        double price = e.getPrice();
        if (this.sellTypes.contains(e.getTransactionType())) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerEarnFromSellEvent(e.getPlayer(), price));
        } else if (this.buyTypes.contains(e.getTransactionType())) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerSpendOnPurchaseEvent(e.getPlayer(), price));
        }
        if (this.sellTypes.contains(e.getTransactionType()) && !e.getItems().isEmpty()) {
            for (Map.Entry entry : e.getItems().entrySet()) {
                TypeId id;
                ItemStack item = ((ShopItem)entry.getKey()).getItemToGive();
                Integer amount = (Integer)entry.getValue();
                if (item == null || (id = AuroraAPI.getItemManager().resolveId(item)) == null) continue;
                Bukkit.getPluginManager().callEvent((Event)new PlayerSellItemEvent(e.getPlayer(), new PlayerSellItemEvent.TransactionItem(id, amount)));
            }
        } else if (this.sellTypes.contains(e.getTransactionType())) {
            TypeId id;
            ItemStack item = e.getShopItem().getItemToGive();
            int amount = e.getAmount();
            if (item != null && (id = AuroraAPI.getItemManager().resolveId(item)) != null) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerSellItemEvent(e.getPlayer(), new PlayerSellItemEvent.TransactionItem(id, amount)));
            }
        } else if (this.buyTypes.contains(e.getTransactionType())) {
            TypeId id;
            ItemStack item = e.getShopItem().getItemToGive();
            int amount = e.getAmount();
            if (item != null && (id = AuroraAPI.getItemManager().resolveId(item)) != null) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerPurchaseItemEvent(e.getPlayer(), new PlayerPurchaseItemEvent.TransactionItem(id, amount)));
            }
        }
    }
}

