/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.luckperms;

import gg.auroramc.aurora.api.reward.PermissionReward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.hooks.Hook;
import gg.auroramc.quests.hooks.luckperms.PermissionCorrector;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LuckPermsHook
implements Hook {
    private AuroraQuests plugin;

    @Override
    public void hook(AuroraQuests plugin) {
        this.plugin = plugin;
        plugin.getPoolManager().getRewardFactory().registerRewardType(NamespacedId.fromDefault((String)"permission"), PermissionReward.class);
        plugin.getPoolManager().getRewardAutoCorrector().registerCorrector(NamespacedId.fromDefault((String)"permission"), (RewardCorrector)new PermissionCorrector());
        LuckPerms lp = LuckPermsProvider.get();
        lp.getEventBus().subscribe(UserDataRecalculateEvent.class, this::onDataRecalculate);
        AuroraQuests.logger().info("Hooked into LuckPerms for permission rewards and for permission start requirements.");
    }

    private synchronized void onDataRecalculate(UserDataRecalculateEvent event) {
        Profile profile;
        Player player = Bukkit.getPlayer((UUID)event.getUser().getUniqueId());
        if (player != null && (profile = this.plugin.getProfileManager().getProfile(player)) != null) {
            for (QuestPool pool : profile.getQuestPools()) {
                pool.unlock(false);
                pool.rollIfNecessary(true);
                pool.startQuests();
            }
        }
    }
}

