/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.luckperms;

import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.PermissionReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.QuestPool;
import java.util.ArrayList;
import java.util.List;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.util.Tristate;
import org.bukkit.entity.Player;

public class PermissionCorrector
implements RewardCorrector {
    public void correctRewards(Player player) {
        AuroraQuests plugin = AuroraQuests.getInstance();
        Profile profile = plugin.getProfileManager().getProfile(player);
        ArrayList<Node> nodesToAdd = new ArrayList<Node>();
        for (QuestPool pool : profile.getQuestPools()) {
            if (pool.isGlobal()) {
                for (Quest quest : pool.getQuests()) {
                    if (!quest.isCompleted()) continue;
                    for (Reward reward : quest.getDefinition().getRewards().values()) {
                        PermissionReward permissionReward;
                        if (!(reward instanceof PermissionReward) || (permissionReward = (PermissionReward)reward).getPermissions() == null || permissionReward.getPermissions().isEmpty()) continue;
                        List nodes = permissionReward.buildNodes(player, quest.getPlaceholders());
                        nodesToAdd.addAll(nodes);
                    }
                }
            }
            if (!pool.hasLeveling()) continue;
            int level = pool.getLevel();
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = pool.getPool().getMatcherManager().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = pool.getLevelPlaceholders(i);
                for (Reward reward : matcher.computeRewards(i)) {
                    PermissionReward permissionReward;
                    if (!(reward instanceof PermissionReward) || (permissionReward = (PermissionReward)reward).getPermissions() == null || permissionReward.getPermissions().isEmpty()) continue;
                    List nodes = permissionReward.buildNodes(player, placeholders);
                    nodesToAdd.addAll(nodes);
                }
            }
        }
        if (nodesToAdd.isEmpty()) {
            return;
        }
        this.updatePermissionNodes(player, nodesToAdd);
    }

    private void updatePermissionNodes(Player player, List<Node> nodes) {
        User user = LuckPermsProvider.get().getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            AuroraQuests.logger().severe("User " + player.getName() + " is not loaded in LuckPerms, failed to correct permission rewards!");
            return;
        }
        int addedNodes = 0;
        for (Node node : nodes) {
            Tristate hasPermission = user.data().contains(node, NodeEqualityPredicate.EXACT);
            if (!hasPermission.equals((Object)Tristate.UNDEFINED)) continue;
            AuroraQuests.logger().debug("Permission " + node.getKey() + " is undefined for player " + player.getName());
            user.data().add(node);
            ++addedNodes;
        }
        if (addedNodes > 0) {
            LuckPermsProvider.get().getUserManager().saveUser(user);
            AuroraQuests.logger().debug("Added " + addedNodes + " permission nodes to player " + player.getName());
        }
    }
}

