/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.mmolib;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.hooks.mmolib.MMOStatReward;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MMOStatCorrector
implements RewardCorrector {
    private final AuroraQuests plugin;

    public MMOStatCorrector(AuroraQuests plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        Profile profile = this.plugin.getProfileManager().getProfile(player);
        MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)player);
        StatMap stats = playerData.getStatMap();
        HashMap statMap = Maps.newHashMap();
        for (QuestPool pool : profile.getQuestPools()) {
            if (pool.isGlobal()) {
                for (Quest quest : pool.getQuests()) {
                    if (!quest.isCompleted()) continue;
                    for (Reward reward : quest.getDefinition().getRewards().values()) {
                        MMOStatReward statReward;
                        if (!(reward instanceof MMOStatReward) || !(statReward = (MMOStatReward)reward).isValid()) continue;
                        String key = NamespacedId.of((String)MMOStatReward.getMMO_STAT(), (String)statReward.getStat()).toString();
                        StatModifier current = statReward.getCurrentModifier(key, stats);
                        UUID uuid = current != null ? current.getUniqueId() : UUID.randomUUID();
                        statMap.merge(statReward.getStat(), new MMOStat(statReward.getModifierType(), statReward.getValue(quest.getPlaceholders()), key, uuid), (a, b) -> new MMOStat(statReward.getModifierType(), a.value() + b.value(), a.key(), a.uuid()));
                    }
                }
            }
            if (!pool.hasLeveling()) continue;
            int level = pool.getLevel();
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = pool.getPool().getMatcherManager().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = pool.getLevelPlaceholders(i);
                for (Reward reward : matcher.computeRewards(i)) {
                    MMOStatReward statReward;
                    if (!(reward instanceof MMOStatReward) || !(statReward = (MMOStatReward)reward).isValid()) continue;
                    String key = NamespacedId.of((String)MMOStatReward.getMMO_STAT(), (String)statReward.getStat()).toString();
                    StatModifier current = statReward.getCurrentModifier(key, stats);
                    UUID uuid = current != null ? current.getUniqueId() : UUID.randomUUID();
                    statMap.merge(statReward.getStat(), new MMOStat(statReward.getModifierType(), statReward.getValue(placeholders), key, uuid), (a, b) -> new MMOStat(statReward.getModifierType(), a.value() + b.value(), a.key(), a.uuid()));
                }
            }
        }
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> {
            for (Map.Entry entry : statMap.entrySet()) {
                String statType = (String)entry.getKey();
                MMOStat s = (MMOStat)entry.getValue();
                new StatModifier(s.uuid, s.key, statType, s.value, s.modifierType, EquipmentSlot.OTHER, ModifierSource.OTHER).register(playerData);
            }
        }, 3L);
    }

    public record MMOStat(ModifierType modifierType, double value, String key, UUID uuid) {
    }
}

