/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.mmolib;

import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.NumberReward;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.quests.AuroraQuests;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class MMOStatReward
extends NumberReward {
    private static final String MMO_STAT = "aurora_quests";
    private String stat;
    private ModifierType modifierType;
    private boolean valid = true;

    public void execute(Player player, long level, List<Placeholder<?>> placeholders) {
        if (!this.valid) {
            return;
        }
        MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)player);
        StatMap statMap = playerData.getStatMap();
        String key = NamespacedId.of((String)MMO_STAT, (String)this.stat).toString();
        StatModifier currentModifier = this.getCurrentModifier(key, statMap);
        double value = this.getValue(placeholders);
        if (currentModifier != null) {
            value += currentModifier.getValue();
            currentModifier.unregister(playerData);
        }
        StatModifier modifier = new StatModifier(key, this.stat, value, this.modifierType);
        modifier.register(playerData);
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)AuroraQuests.getInstance(), task -> statMap.getInstance(this.stat).update(), 3L);
    }

    public void init(ConfigurationSection args) {
        super.init(args);
        this.stat = args.getString("stat");
        if (this.stat == null) {
            this.valid = false;
            AuroraQuests.logger().warning("Stat is not defined in MMOStatReward");
        }
        this.modifierType = ModifierType.valueOf((String)args.getString("modifier", "FLAT"));
    }

    @Nullable
    public StatModifier getCurrentModifier(String key, StatMap statMap) {
        for (StatModifier stat : statMap.getInstance(this.stat).getModifiers()) {
            if (!stat.getKey().equals(key)) continue;
            return stat;
        }
        return null;
    }

    public String getStat() {
        return this.stat;
    }

    public ModifierType getModifierType() {
        return this.modifierType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static String getMMO_STAT() {
        return MMO_STAT;
    }
}

