/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.mythicmobs.reward;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.hooks.mythicmobs.reward.MythicStatReward;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class MythicStatCorrector
implements RewardCorrector {
    public void correctRewards(Player player) {
        AuroraQuests plugin = AuroraQuests.getInstance();
        Profile profile = plugin.getProfileManager().getProfile(player);
        MythicBukkit mythic = MythicBukkit.inst();
        StatRegistry registry = ((PlayerData)mythic.getPlayerManager().getProfile(player)).getStatRegistry();
        HashMap statMap = Maps.newHashMap();
        mythic.getStatManager().getStats().values().forEach(statType -> {
            if (!statType.isEnabled()) {
                return;
            }
            registry.removeValue(statType, MythicStatReward.getSource());
        });
        for (QuestPool questPool : profile.getQuestPools()) {
            Object statReward;
            if (questPool.isGlobal()) {
                for (Quest quest : questPool.getQuests()) {
                    if (!quest.isCompleted()) continue;
                    for (Reward reward : quest.getDefinition().getRewards().values()) {
                        if (!(reward instanceof MythicStatReward) || !((MythicStatReward)((Object)(statReward = (MythicStatReward)reward))).isValid()) continue;
                        statMap.computeIfAbsent(((MythicStatReward)((Object)statReward)).getStatType(), key -> Maps.newHashMap()).merge(((MythicStatReward)((Object)statReward)).getModifierType(), statReward.getValue(quest.getPlaceholders()), Double::sum);
                    }
                }
            }
            if (!questPool.hasLeveling()) continue;
            int level = questPool.getLevel();
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = questPool.getPool().getMatcherManager().getBestMatcher(i);
                if (matcher == null) continue;
                List<Placeholder<?>> placeholders = questPool.getLevelPlaceholders(i);
                statReward = matcher.computeRewards(i).iterator();
                while (statReward.hasNext()) {
                    MythicStatReward statReward2;
                    Reward reward = (Reward)statReward.next();
                    if (!(reward instanceof MythicStatReward) || !(statReward2 = (MythicStatReward)reward).isValid()) continue;
                    statMap.computeIfAbsent(statReward2.getStatType(), key -> Maps.newHashMap()).merge(statReward2.getModifierType(), statReward2.getValue(placeholders), Double::sum);
                }
            }
        }
        for (Map.Entry entry : statMap.entrySet()) {
            StatType statType2 = (StatType)entry.getKey();
            for (Map.Entry modifierEntry : ((Map)entry.getValue()).entrySet()) {
                StatModifierType modifierType = (StatModifierType)modifierEntry.getKey();
                Double value = (Double)modifierEntry.getValue();
                AuroraQuests.logger().debug("Adding stat " + statType2.getKey() + " with value " + value + " to player " + player.getName());
                registry.putValue(statType2, MythicStatReward.getSource(), modifierType, value.doubleValue());
            }
        }
    }
}

