/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.hooks.superiorskyblock;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.events.IslandCreateEvent;
import com.bgsoftware.superiorskyblock.api.events.IslandJoinEvent;
import com.bgsoftware.superiorskyblock.api.events.IslandUpgradeEvent;
import com.bgsoftware.superiorskyblock.api.events.IslandWorthCalculatedEvent;
import com.bgsoftware.superiorskyblock.api.events.IslandWorthUpdateEvent;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.wrappers.SuperiorPlayer;
import gg.auroramc.aurora.api.events.user.AuroraUserLoadedEvent;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.event.objective.PlayerIslandLevelChangeEvent;
import gg.auroramc.quests.api.event.objective.PlayerIslandWorthChangeEvent;
import gg.auroramc.quests.api.event.objective.PlayerJoinIslandEvent;
import gg.auroramc.quests.api.event.objective.PlayerUpgradeIslandEvent;
import gg.auroramc.quests.hooks.Hook;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SuperiorSkyblockHook
implements Hook,
Listener {
    private AuroraQuests plugin;

    @Override
    public void hook(AuroraQuests plugin) {
        this.plugin = plugin;
        AuroraQuests.logger().info("Hooked SuperiorSkyblock2 for island hooks.");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onIslandCreate(IslandCreateEvent event) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerJoinIslandEvent(event.getPlayer().asPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onIslandJoin(IslandJoinEvent event) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerJoinIslandEvent(event.getPlayer().asPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onIslandWorthCalc(IslandWorthCalculatedEvent event) {
        double worth = event.getWorth().doubleValue();
        double level = event.getLevel().doubleValue();
        this.updateIslandMembers(worth, level, event.getIsland());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onIslandWorthCalc(IslandWorthUpdateEvent event) {
        double worth = event.getNewWorth().doubleValue();
        double level = event.getNewLevel().doubleValue();
        this.updateIslandMembers(worth, level, event.getIsland());
    }

    @EventHandler
    public void onUserLoaded(AuroraUserLoadedEvent event) {
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)AuroraQuests.getInstance(), task -> {
            Player player = event.getUser().getPlayer();
            if (player == null || !player.isOnline()) {
                return;
            }
            Island island = SuperiorSkyblockAPI.getPlayer((Player)player).getIsland();
            if (island != null) {
                this.updateIslandMembers(island.getWorth().doubleValue(), island.getIslandLevel().doubleValue(), island);
                this.updateIslandUpgrades(island);
            }
        }, 100L);
    }

    private void updateIslandMembers(double worth, double level, Island island) {
        for (SuperiorPlayer sPlayer : island.getIslandMembers(true)) {
            Player player = sPlayer.asPlayer();
            if (player == null) continue;
            Bukkit.getPluginManager().callEvent((Event)new PlayerIslandLevelChangeEvent(player, level));
            Bukkit.getPluginManager().callEvent((Event)new PlayerIslandWorthChangeEvent(player, worth));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onIslandUpgrade(IslandUpgradeEvent event) {
        Island island = event.getIsland();
        for (SuperiorPlayer sPlayer : island.getIslandMembers(true)) {
            Player player = sPlayer.asPlayer();
            if (player == null) continue;
            Bukkit.getPluginManager().callEvent((Event)new PlayerUpgradeIslandEvent(player, event.getUpgrade().getName(), event.getUpgradeLevel().getLevel()));
        }
    }

    private void updateIslandUpgrades(Island island) {
        for (Map.Entry upgrade : island.getUpgrades().entrySet()) {
            for (SuperiorPlayer sPlayer : island.getIslandMembers(true)) {
                Player player = sPlayer.asPlayer();
                if (player == null) continue;
                Bukkit.getPluginManager().callEvent((Event)new PlayerUpgradeIslandEvent(player, (String)upgrade.getKey(), (Integer)upgrade.getValue()));
            }
        }
    }
}

