/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.menu;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.config.CommonMenuConfig;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.menu.PoolMenu;
import gg.auroramc.quests.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class LevelMenu {
    private final Profile profile;
    private final QuestPool pool;
    private int page = 0;
    private final Runnable backAction;

    public LevelMenu(Profile profile, QuestPool pool, @Nullable Runnable backAction) {
        this.profile = profile;
        this.pool = pool;
        this.backAction = Objects.requireNonNullElseGet(backAction, () -> () -> new PoolMenu(profile, pool).open());
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        LocalizationProvider localization = AuroraQuests.getInstance().getLocalizationProvider();
        PoolConfig.Leveling cf = this.pool.getPool().getDefinition().getLeveling();
        PoolConfig.LevelingMenu cm = cf.getMenu();
        CommonMenuConfig cmf = AuroraQuests.getInstance().getConfigManager().getCommonMenuConfig();
        Player player = this.profile.getPlayer();
        AuroraMenu menu = new AuroraMenu(player, cm.getTitle(), cm.getRows() * 9, false, localization, new Placeholder[]{Placeholder.of((String)"{name}", (String)this.pool.getName())});
        if (cm.getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)cm.getFiller().getItem()).localization(localization).toItemStack(player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        if (cm.getHasBackButton().booleanValue()) {
            menu.addItem(ItemBuilder.back((ItemConfig)cmf.getItems().get("back").merge(cm.getItems().get("back"))).localization(localization).build(player), e -> this.backAction.run());
        }
        if (cm.getHasCloseButton().booleanValue()) {
            menu.addItem(ItemBuilder.close((ItemConfig)cmf.getItems().get("close").merge(cm.getItems().get("close"))).localization(localization).build(player), e -> player.closeInventory());
        }
        int level = this.pool.getLevel();
        List<Placeholder> placeholders = List.of(Placeholder.of((String)"{name}", (String)this.pool.getPool().getDefinition().getName()), Placeholder.of((String)"{level}", (String)AuroraAPI.formatNumber((long)level)), Placeholder.of((String)"{level_roman}", (String)RomanNumber.toRoman(level)), Placeholder.of((String)"{level_raw}", (Number)level));
        for (ItemConfig customItem : cm.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).localization(localization).placeholder(placeholders).build(player));
        }
        List<Integer> requirements = this.getPage(this.page, cm.getDisplayArea().size());
        for (int i = 0; i < cm.getDisplayArea().size(); ++i) {
            Integer slot = cm.getDisplayArea().get(i);
            if (requirements.size() <= i) break;
            Integer requirement = requirements.get(i);
            int rLevel = cf.getRequirements().indexOf(requirement) + 1;
            boolean completed = level >= rLevel;
            ItemConfig itemConfig = completed ? cmf.getItems().get("completed-level").merge(cm.getItems().get("completed-level")) : cmf.getItems().get("locked-level").merge(cm.getItems().get("locked-level"));
            List rewards = this.pool.getPool().getMatcherManager().getBestMatcher(rLevel).computeRewards(rLevel);
            long currentProgress = Math.min(this.pool.getCompletedQuestCount(), (long)requirement.intValue());
            CommonMenuConfig.ProgressBar bar = cmf.getProgressBar();
            Integer pcs = bar.getLength();
            double completedPercent = Math.min((double)currentProgress / (double)requirement.intValue(), 1.0);
            int completedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * completedPercent)).intValue();
            int remainingPcs = pcs - completedPcs;
            ArrayList<String> lore = new ArrayList<String>();
            List<Placeholder> rPlaceholders = List.of(Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{pool}", (String)this.pool.getName()), Placeholder.of((String)"{pool_id}", (String)this.pool.getId()), Placeholder.of((String)"{level}", (String)AuroraAPI.formatNumber((long)rLevel)), Placeholder.of((String)"{level_roman}", (String)RomanNumber.toRoman(rLevel)), Placeholder.of((String)"{level_raw}", (Number)rLevel), Placeholder.of((String)"{current}", (String)AuroraAPI.formatNumber((long)currentProgress)), Placeholder.of((String)"{required}", (String)AuroraAPI.formatNumber((long)requirement.intValue())), Placeholder.of((String)"{progressbar}", (String)(bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r")), Placeholder.of((String)"{progress_percent}", (Number)Math.round(completedPercent * 100.0)));
            for (String line : itemConfig.getLore()) {
                if (line.equals("component:rewards")) {
                    Config.DisplayComponent display = cmf.getDisplayComponents().get("rewards");
                    if (!rewards.isEmpty()) {
                        lore.add(display.getTitle());
                    }
                    for (Reward reward : rewards) {
                        lore.add(display.getLine().replace("{reward}", reward.getDisplay(player, rPlaceholders)));
                    }
                    continue;
                }
                lore.add(line);
            }
            ItemBuilder builder = ItemBuilder.of((ItemConfig)itemConfig).slot(slot.intValue()).localization(localization).loreCompute(() -> lore.stream().map(l -> Text.component((Player)player, (String)localization.fillVariables(player, l, rPlaceholders), (Placeholder[])new Placeholder[0])).toList()).placeholder(rPlaceholders);
            if (cm.getAllowItemAmounts().booleanValue()) {
                builder.amount(rLevel);
            }
            menu.addItem(builder.build(player));
        }
        if (cf.getRequirements().size() > cm.getDisplayArea().size()) {
            int pageCount = this.getTotalPageCount(cm.getDisplayArea().size());
            List<Placeholder> pl = List.of(Placeholder.of((String)"{current}", (Number)(this.page + 1)), Placeholder.of((String)"{max}", (Number)(pageCount + 1)));
            menu.addItem(ItemBuilder.of((ItemConfig)cmf.getItems().get("previous-page").merge(cm.getItems().get("previous-page"))).localization(localization).placeholder(pl).build(player), e -> {
                if (this.page > 0) {
                    --this.page;
                    this.createMenu().open();
                }
            });
            menu.addItem(ItemBuilder.of((ItemConfig)cmf.getItems().get("current-page").merge(cm.getItems().get("current-page"))).localization(localization).placeholder(pl).build(player));
            menu.addItem(ItemBuilder.of((ItemConfig)cmf.getItems().get("next-page").merge(cm.getItems().get("next-page"))).localization(localization).placeholder(pl).build(player), e -> {
                if (this.page < pageCount) {
                    ++this.page;
                    this.createMenu().open();
                }
            });
        }
        return menu;
    }

    private List<Integer> getPage(int page, int pageSize) {
        List<Integer> requirements = this.pool.getPool().getDefinition().getLeveling().getRequirements();
        return requirements.stream().skip((long)page * (long)pageSize).limit(pageSize).toList();
    }

    private int getTotalPageCount(int pageSize) {
        List<Integer> requirements = this.pool.getPool().getDefinition().getLeveling().getRequirements();
        return (int)Math.ceil((double)requirements.size() / (double)pageSize) - 1;
    }
}

