/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.menu;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.config.CommonMenuConfig;
import gg.auroramc.quests.config.MainMenuConfig;
import gg.auroramc.quests.menu.PoolMenu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class MainMenu {
    private final Profile profile;
    private int page = 1;
    private int maxPage = 1;

    public MainMenu(Profile profile) {
        this.profile = profile;
    }

    public void open() {
        this.createMenu().open();
    }

    private ItemConfig merge(CommonMenuConfig cmf, MainMenuConfig mc, String key) {
        return cmf.getItems().get(key).merge(mc.getItems().get(key));
    }

    private AuroraMenu createMenu() {
        Collection<QuestPool> pools;
        OptionalInt maybeInt;
        LocalizationProvider localization = AuroraQuests.getInstance().getLocalizationProvider();
        MainMenuConfig config = AuroraQuests.getInstance().getConfigManager().getMainMenuConfig();
        CommonMenuConfig cmf = AuroraQuests.getInstance().getConfigManager().getCommonMenuConfig();
        Player player = this.profile.getPlayer();
        AuroraMenu menu = new AuroraMenu(player, config.getTitle(), config.getMenuRows() * 9, false, localization, new Placeholder[0]);
        if (config.getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)config.getFiller().getItem()).localization(localization).toItemStack(player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        if (config.getHasCloseButton().booleanValue()) {
            menu.addItem(ItemBuilder.close((ItemConfig)this.merge(cmf, config, "close")).localization(localization).build(player), e -> player.closeInventory());
        }
        if ((maybeInt = (pools = this.profile.getQuestPools()).stream().filter(pool -> pool.getDefinition().getMenuItem().getShowInMainMenu()).filter(pool -> pool.isUnlocked() || pool.getDefinition().getRequirement().isAlwaysShowInMenu()).mapToInt(pool -> pool.getDefinition().getMenuItem().getPage()).max()).isPresent()) {
            this.maxPage = maybeInt.getAsInt();
        }
        AuroraUser user = AuroraAPI.getUser((UUID)player.getUniqueId());
        LeaderboardExpansion lbm = AuroraAPI.getLeaderboards();
        for (QuestPool pool2 : pools) {
            PoolConfig.PoolMenuItem mi;
            if (!pool2.isUnlocked() && !pool2.getDefinition().getRequirement().isAlwaysShowInMenu() || !(mi = pool2.getDefinition().getMenuItem()).getShowInMainMenu().booleanValue() || mi.getPage() != this.page) continue;
            String boardName = "quests_" + pool2.getId();
            ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>();
            LbEntry lb = (LbEntry)user.getLeaderboardEntries().get(boardName);
            if (lb != null && lb.getPosition() != 0L) {
                placeholders.add(Placeholder.of((String)"{lb_position}", (String)AuroraAPI.formatNumber((long)lb.getPosition())));
                placeholders.add(Placeholder.of((String)"{lb_position_percent}", (String)AuroraAPI.formatNumber((double)Math.min((double)lb.getPosition() / (double)Math.max(1L, AuroraAPI.getLeaderboards().getBoardSize(boardName)) * 100.0, 100.0))));
                placeholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max(Math.max(lb.getPosition(), (long)Bukkit.getOnlinePlayers().size()), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
            } else {
                placeholders.add(Placeholder.of((String)"{lb_position}", (String)lbm.getEmptyPlaceholder()));
                placeholders.add(Placeholder.of((String)"{lb_position_percent}", (String)lbm.getEmptyPlaceholder()));
                placeholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max((long)Bukkit.getOnlinePlayers().size(), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
            }
            ArrayList<String> lore = new ArrayList<String>();
            if (!pool2.isUnlocked()) {
                lore.addAll(mi.getLockedLore());
            }
            menu.addItem(ItemBuilder.of((ItemConfig)mi.getItem()).setName(Placeholder.execute((String)mi.getItem().getName(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{name}", (String)pool2.getDefinition().getName())})).localization(localization).extraLore(lore).placeholder(Placeholder.of((String)"{name}", (String)pool2.getDefinition().getName())).placeholder(Placeholder.of((String)"{total_completed}", (String)AuroraAPI.formatNumber((long)pool2.getCompletedQuestCount()))).placeholder(placeholders).build(player), e -> {
                if (pool2.isUnlocked()) {
                    new PoolMenu(this.profile, pool2).open();
                }
            });
        }
        for (ItemConfig customItem : config.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).localization(localization).build(player));
        }
        if (this.maxPage > 1) {
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{current}", (Number)this.page), Placeholder.of((String)"{total}", (Number)this.maxPage));
            menu.addItem(ItemBuilder.of((ItemConfig)this.merge(cmf, config, "previous-page")).localization(localization).placeholder(placeholders).build(player), e -> {
                if (this.page > 1) {
                    --this.page;
                    this.createMenu().open();
                }
            });
            menu.addItem(ItemBuilder.of((ItemConfig)this.merge(cmf, config, "current-page")).localization(localization).placeholder(placeholders).build(player));
            menu.addItem(ItemBuilder.of((ItemConfig)this.merge(cmf, config, "next-page")).localization(localization).placeholder(placeholders).build(player), e -> {
                if (this.page < this.maxPage) {
                    ++this.page;
                    this.createMenu().open();
                }
            });
        }
        return menu;
    }
}

