/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.menu;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.localization.LocalizationProvider;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.event.objective.PlayerTakeItemEvent;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.api.questpool.PoolConfig;
import gg.auroramc.quests.api.questpool.PoolDefinition;
import gg.auroramc.quests.api.questpool.QuestPool;
import gg.auroramc.quests.config.CommonMenuConfig;
import gg.auroramc.quests.config.Config;
import gg.auroramc.quests.menu.LevelMenu;
import gg.auroramc.quests.menu.MainMenu;
import gg.auroramc.quests.util.RomanNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PoolMenu {
    private final Profile profile;
    private final QuestPool pool;
    private int page = 0;
    private boolean isCompletedQuests = false;
    private final Runnable backAction;

    public PoolMenu(Profile profile, QuestPool pool, @Nullable Runnable backAction) {
        this.profile = profile;
        this.pool = pool;
        this.backAction = backAction;
    }

    public PoolMenu(Profile profile, QuestPool pool) {
        this(profile, pool, null);
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        LocalizationProvider localization = AuroraQuests.getInstance().getLocalizationProvider();
        PoolDefinition config = this.pool.getPool().getDefinition();
        PoolConfig.PoolMenu mc = config.getMenu();
        CommonMenuConfig cmf = AuroraQuests.getInstance().getConfigManager().getCommonMenuConfig();
        Player player = this.profile.getPlayer();
        AuroraMenu menu = new AuroraMenu(player, Placeholder.execute((String)mc.getTitle(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{name}", (String)config.getName())}), mc.getRows() * 9, false, localization, new Placeholder[]{Placeholder.of((String)"{name}", (String)config.getName())});
        if (config.getMenu().getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)mc.getFiller().getItem()).localization(localization).toItemStack(player));
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        Placeholder totalCompletedPlaceholder = Placeholder.of((String)"{total_completed}", (String)AuroraAPI.formatNumber((long)this.pool.getCompletedQuestCount()));
        Placeholder levelPlaceholder = Placeholder.of((String)"{level}", (String)AuroraAPI.formatNumber((long)this.pool.getLevel()));
        Placeholder levelRawPlaceholder = Placeholder.of((String)"{level_raw}", (Number)this.pool.getLevel());
        Placeholder levelRomanPlaceholder = Placeholder.of((String)"{level_roman}", (String)RomanNumber.toRoman(this.pool.getLevel()));
        LeaderboardExpansion lbm = AuroraAPI.getLeaderboards();
        String boardName = "quests_" + this.pool.getId();
        AuroraUser user = AuroraAPI.getUser((UUID)player.getUniqueId());
        ArrayList<Placeholder> lbPlaceholders = new ArrayList<Placeholder>();
        LbEntry lb = (LbEntry)user.getLeaderboardEntries().get(boardName);
        if (lb != null && lb.getPosition() != 0L) {
            lbPlaceholders.add(Placeholder.of((String)"{lb_position}", (String)AuroraAPI.formatNumber((long)lb.getPosition())));
            lbPlaceholders.add(Placeholder.of((String)"{lb_position_percent}", (String)AuroraAPI.formatNumber((double)Math.min((double)lb.getPosition() / (double)Math.max(1L, AuroraAPI.getLeaderboards().getBoardSize(boardName)) * 100.0, 100.0))));
            lbPlaceholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max(Math.max(lb.getPosition(), (long)Bukkit.getOnlinePlayers().size()), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
        } else {
            lbPlaceholders.add(Placeholder.of((String)"{lb_position}", (String)lbm.getEmptyPlaceholder()));
            lbPlaceholders.add(Placeholder.of((String)"{lb_position_percent}", (String)lbm.getEmptyPlaceholder()));
            lbPlaceholders.add(Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max((long)Bukkit.getOnlinePlayers().size(), AuroraAPI.getLeaderboards().getBoardSize(boardName)))));
        }
        for (ItemConfig customItem : config.getMenu().getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).localization(localization).placeholder(totalCompletedPlaceholder).placeholder(Placeholder.of((String)"{name}", (String)config.getName())).placeholder(levelPlaceholder).placeholder(levelRawPlaceholder).placeholder(levelRomanPlaceholder).placeholder(lbPlaceholders).build(player));
        }
        if (mc.getHasCloseButton().booleanValue()) {
            ItemConfig closeConfig = cmf.getItems().get("close").merge(mc.getItems().get("close"));
            menu.addItem(ItemBuilder.close((ItemConfig)closeConfig).localization(localization).build(player), e -> player.closeInventory());
        }
        if (mc.getHasBackButton().booleanValue()) {
            ItemConfig backConfig = cmf.getItems().get("back").merge(mc.getItems().get("back"));
            menu.addItem(ItemBuilder.back((ItemConfig)backConfig).localization(localization).build(player), e -> {
                if (this.backAction != null) {
                    this.backAction.run();
                } else {
                    new MainMenu(this.profile).open();
                }
            });
        }
        List<Quest> quests = this.getPage(this.page, mc.getDisplayArea().size());
        for (int i = 0; i < mc.getDisplayArea().size(); ++i) {
            Integer slot = mc.getDisplayArea().get(i);
            if (quests.size() <= i) {
                menu.addItem(ItemBuilder.item((ItemStack)new ItemStack(Material.AIR)).slot(slot.intValue()).build(player));
                continue;
            }
            Quest quest = quests.get(i);
            ArrayList<String> extraLore = new ArrayList<String>();
            if (quest.isCompleted()) {
                extraLore.addAll(quest.getDefinition().getCompletedLore());
            } else if (quest.getDefinition().getUncompletedLore() != null) {
                extraLore.addAll(quest.getDefinition().getUncompletedLore());
            }
            if (!quest.isUnlocked() && this.pool.isGlobal()) {
                extraLore.addAll(quest.getDefinition().getLockedLore());
            }
            List<Placeholder<?>> qPlaceholders = quest.getPlaceholders();
            ItemBuilder builder = ItemBuilder.of((ItemConfig)quest.getDefinition().getMenuItem()).slot(slot.intValue()).setName(Placeholder.execute((String)quest.getDefinition().getMenuItem().getName(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{name}", (String)quest.getDefinition().getName())})).setLore(quest.getDefinition().getMenuItem().getLore().stream().map(l -> Placeholder.execute((String)l, (List)qPlaceholders)).toList()).localization(localization).placeholder(qPlaceholders).extraLore(extraLore);
            if ((quest.isUnlocked() || !this.pool.isGlobal()) && !quest.isCompleted() && quest.getDefinition().getTasks().values().stream().anyMatch(t -> t.getTask().equals("TAKE_ITEM"))) {
                menu.addItem(builder.build(player), e -> {
                    Bukkit.getPluginManager().callEvent((Event)new PlayerTakeItemEvent(player, quest));
                    this.createMenu().open(player);
                });
                continue;
            }
            menu.addItem(builder.build(player));
        }
        if (this.getQuests().size() > mc.getDisplayArea().size()) {
            int pageCount = this.getTotalPageCount(mc.getDisplayArea().size());
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{current}", (Number)(this.page + 1)), Placeholder.of((String)"{max}", (Number)(pageCount + 1)));
            menu.addItem(ItemBuilder.of((ItemConfig)cmf.getItems().get("previous-page").merge(mc.getItems().get("previous-page"))).localization(localization).placeholder(placeholders).build(player), e -> {
                if (this.page > 0) {
                    --this.page;
                    this.createMenu().open();
                }
            });
            menu.addItem(ItemBuilder.of((ItemConfig)cmf.getItems().get("current-page").merge(mc.getItems().get("current-page"))).localization(localization).placeholder(placeholders).build(player));
            menu.addItem(ItemBuilder.of((ItemConfig)cmf.getItems().get("next-page").merge(mc.getItems().get("next-page"))).localization(localization).placeholder(placeholders).build(player), e -> {
                if (this.page < pageCount) {
                    ++this.page;
                    this.createMenu().open();
                }
            });
        }
        if (this.pool.isGlobal()) {
            if (this.isCompletedQuests) {
                MenuItem item = ItemBuilder.of((ItemConfig)cmf.getItems().get("switch-to-active").merge(mc.getItems().get("switch-to-active"))).localization(localization).placeholder(Placeholder.of((String)"{name}", (String)config.getName())).build(player);
                menu.addItem(item, e -> {
                    this.isCompletedQuests = false;
                    this.page = 0;
                    this.createMenu().open();
                });
            } else {
                MenuItem item = ItemBuilder.of((ItemConfig)cmf.getItems().get("switch-to-completed").merge(mc.getItems().get("switch-to-completed"))).localization(localization).placeholder(Placeholder.of((String)"{name}", (String)config.getName())).placeholder(totalCompletedPlaceholder).build(player);
                menu.addItem(item, e -> {
                    this.isCompletedQuests = true;
                    this.page = 0;
                    this.createMenu().open();
                });
            }
        }
        if (this.pool.hasLeveling()) {
            MenuItem item = ItemBuilder.of((ItemConfig)cmf.getItems().get("switch-to-levels").merge(mc.getItems().get("switch-to-levels"))).localization(localization).placeholder(Placeholder.of((String)"{name}", (String)config.getName())).placeholder(totalCompletedPlaceholder).placeholder(levelPlaceholder).placeholder(levelRawPlaceholder).placeholder(levelRomanPlaceholder).placeholder(lbPlaceholders).build(player);
            menu.addItem(item, e -> {
                if (this.backAction != null) {
                    new LevelMenu(this.profile, this.pool, () -> new PoolMenu(this.profile, this.pool, this.backAction).open()).open();
                } else {
                    new LevelMenu(this.profile, this.pool, null).open();
                }
            });
        }
        return menu;
    }

    private Collection<Quest> getQuests() {
        Config gc = AuroraQuests.getInstance().getConfigManager().getConfig();
        List<Quest> quests = this.pool.isGlobal() ? (this.isCompletedQuests ? this.pool.getQuests().stream().filter(Quest::isCompleted).sorted(Comparator.comparing(Quest::getId)).toList() : this.pool.getQuests().stream().filter(q -> !q.isCompleted()).filter(q -> q.isUnlocked() || q.getDefinition().getRequirements().isAlwaysShowInMenu()).sorted(Comparator.comparing(Quest::getId)).toList()) : this.pool.getActiveQuests().stream().sorted(Comparator.comparing(a -> gc.getSortOderMap().get(a.getDefinition().getDifficulty()))).toList();
        return quests;
    }

    private List<Quest> getPage(int page, int pageSize) {
        Collection<Quest> quests = this.getQuests();
        return quests.stream().skip((long)page * (long)pageSize).limit(pageSize).toList();
    }

    private int getTotalPageCount(int pageSize) {
        Collection<Quest> quests = this.getQuests();
        return (int)Math.ceil((double)quests.size() / (double)pageSize) - 1;
    }
}

