/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.event.objective.PlayerLootEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.util.AnnoyingPluginUtil;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class BlockLootObjective
extends TypedObjective {
    private static final Set<Material> blacklist = Set.of(Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL, Material.HOPPER, Material.FURNACE, Material.SMOKER, Material.BLAST_FURNACE, Material.DISPENSER, Material.ITEM_FRAME, Material.BEACON, Material.DROPPER, Material.ARMOR_STAND, Material.BREWING_STAND, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.FLOWER_POT, Material.JUKEBOX, Material.LOOM, Material.CARTOGRAPHY_TABLE, Material.DECORATED_POT);

    public BlockLootObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(BlockDropItemEvent.class, this::onBlockDrop, AnnoyingPluginUtil.getBlockDropItemPriority());
        this.onEvent(PlayerLootEvent.class, this::handleCustomLoot, EventPriority.MONITOR);
    }

    public void onBlockDrop(BlockDropItemEvent e) {
        if (AuroraAPI.getRegionManager().isPlacedBlock(e.getBlock())) {
            return;
        }
        if (e.getPlayer() != this.data.profile().getPlayer()) {
            return;
        }
        if (blacklist.contains(e.getBlockState().getType())) {
            return;
        }
        for (Item drop : e.getItems()) {
            ItemStack item = drop.getItemStack();
            TypeId id = AuroraAPI.getItemManager().resolveId(item);
            this.progress(item.getAmount(), this.meta(e.getBlock().getLocation(), id));
        }
    }

    public void handleCustomLoot(PlayerLootEvent event) {
        if (event.getSource() == PlayerLootEvent.Source.BLOCK || event.getSource() == PlayerLootEvent.Source.ALL) {
            this.progress(event.getAmount(), this.meta(event.getType()));
        }
    }
}

