/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityBreedEvent;

public class BreedingObjective
extends TypedObjective {
    public BreedingObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(EntityFertilizeEggEvent.class, this::onBreedEgg, EventPriority.MONITOR);
        this.onEvent(EntityBreedEvent.class, this::onBreed, EventPriority.MONITOR);
    }

    public void onBreedEgg(EntityFertilizeEggEvent event) {
        Player player = event.getBreeder();
        if (player == this.data.profile().getPlayer()) {
            this.progress(1.0, this.meta(event.getEntity().getType()));
        }
    }

    public void onBreed(EntityBreedEvent event) {
        Player player;
        LivingEntity breeder = event.getBreeder();
        if (breeder instanceof Player && (player = (Player)breeder) == this.data.profile().getPlayer()) {
            this.progress(1.0, this.meta(event.getEntity().getType()));
        }
    }
}

