/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.util.BukkitPotionType;
import gg.auroramc.aurora.api.util.Version;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.StringTypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;

public class BrewingObjective
extends StringTypedObjective {
    private final Map<Location, Player> brewingStands = new ConcurrentHashMap<Location, Player>();

    public BrewingObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(InventoryOpenEvent.class, this::onInventoryOpen, EventPriority.MONITOR);
        this.onEvent(BrewEvent.class, this::onBrew, EventPriority.MONITOR);
    }

    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder == null) {
            return;
        }
        if (player == this.data.profile().getPlayer()) {
            this.brewingStands.put(inventory.getLocation(), player);
        } else {
            this.brewingStands.remove(inventory.getLocation());
        }
    }

    public void onBrew(BrewEvent event) {
        Player player = this.brewingStands.remove(event.getBlock().getLocation());
        if (player == null) {
            return;
        }
        ItemStack[] currentResults = (ItemStack[])Stream.of(event.getContents().getStorageContents()).map(stack -> stack == null ? ItemStack.empty() : stack.clone()).toArray(ItemStack[]::new);
        Bukkit.getRegionScheduler().run((Plugin)AuroraQuests.getInstance(), event.getBlock().getLocation(), t -> {
            ItemStack[] newResults = (ItemStack[])Stream.of(event.getContents().getStorageContents()).map(stack -> stack == null ? ItemStack.empty() : stack).toArray(ItemStack[]::new);
            ArrayList<ObjectiveMeta> metas = new ArrayList<ObjectiveMeta>();
            for (int i = 0; i < 3; ++i) {
                ItemMeta patt0$temp;
                if (currentResults[i].equals((Object)newResults[i])) continue;
                ItemStack item = newResults[i];
                if (!item.isEmpty() && item.hasItemMeta() && (patt0$temp = item.getItemMeta()) instanceof PotionMeta) {
                    PotionMeta meta = (PotionMeta)patt0$temp;
                    BukkitPotionType type = new BukkitPotionType(meta);
                    Object typeString = type.getType().name().toLowerCase(Locale.ROOT);
                    if (!Version.isAtLeastVersion((int)20, (int)2)) {
                        if (type.isExtended()) {
                            typeString = "long_" + (String)typeString;
                        } else if (type.isUpgraded()) {
                            typeString = "strong_" + (String)typeString;
                        }
                    }
                    metas.add(this.meta(event.getBlock().getLocation(), (String)typeString));
                    continue;
                }
                if (item.isEmpty()) continue;
                metas.add(this.meta(event.getBlock().getLocation(), AuroraAPI.getItemManager().resolveId(item).toString()));
            }
            player.getScheduler().run((Plugin)AuroraQuests.getInstance(), t2 -> {
                for (ObjectiveMeta meta : metas) {
                    this.progress(1.0, meta);
                }
            }, null);
        });
    }
}

