/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.quests.api.event.objective.PlayerCraftedItemEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.util.InventoryUtils;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CraftObjective
extends TypedObjective {
    public CraftObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(CraftItemEvent.class, this::onCraftItem, EventPriority.MONITOR);
        this.onEvent(PlayerCraftedItemEvent.class, this::onCraftItem, EventPriority.MONITOR);
    }

    public void onCraftItem(CraftItemEvent event) {
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player && (player = (Player)humanEntity) == this.data.profile().getPlayer()) {
            ItemStack item = event.getRecipe().getResult();
            if (item.isEmpty()) {
                return;
            }
            this.progress(CraftObjective.calculateCraftAmount(event), this.meta(AuroraAPI.getItemManager().resolveId(item)));
        }
    }

    public void onCraftItem(PlayerCraftedItemEvent event) {
        this.progress(event.getAmount(), this.meta(event.getItem()));
    }

    private static int calculateCraftAmount(CraftItemEvent event) {
        ItemStack result = event.getRecipe().getResult();
        PlayerInventory inventory = event.getWhoClicked().getInventory();
        ItemStack[] ingredients = event.getInventory().getMatrix();
        return switch (event.getClick()) {
            case ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT -> InventoryUtils.calculateShiftCraftAmount(result, (Inventory)inventory, ingredients);
            case ClickType.CONTROL_DROP -> InventoryUtils.calculateMaximumCraftAmount(result, ingredients);
            case ClickType.NUMBER_KEY -> InventoryUtils.calculateSwapCraftAmount(result, inventory.getItem(event.getHotbarButton()));
            case ClickType.SWAP_OFFHAND -> InventoryUtils.calculateSwapCraftAmount(result, inventory.getItemInOffHand());
            case ClickType.DROP -> InventoryUtils.calculateDropCraftAmount(result, event.getCursor());
            case ClickType.LEFT, ClickType.RIGHT -> InventoryUtils.calculateSimpleCraftAmount(result, event.getCursor());
            default -> 0;
        };
    }
}

