/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DealDamageObjective
extends TypedObjective {
    private final boolean countPlayerDamage;

    public DealDamageObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
        this.countPlayerDamage = definition.getArgs().getBoolean("count-player-damage", false);
    }

    @Override
    protected void activate() {
        this.onEvent(EntityDamageByEntityEvent.class, this::handle, EventPriority.MONITOR);
    }

    public void handle(EntityDamageByEntityEvent event) {
        Player player;
        Entity damager = event.getDamager();
        if (!(damager instanceof Player) || (player = (Player)damager) != this.data.profile().getPlayer()) {
            return;
        }
        if (event.getEntity() instanceof Player && !this.countPlayerDamage) {
            return;
        }
        TypeId id = AuroraAPI.getEntityManager().resolveId(event.getEntity());
        this.progress(event.getFinalDamage(), this.meta(id));
    }
}

