/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import com.google.common.collect.Lists;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import gg.auroramc.quests.api.objective.filter.RangeFilter;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.List;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class EnchantObjective
extends TypedObjective {
    public EnchantObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(EnchantItemEvent.class, this::onEnchant, EventPriority.MONITOR);
    }

    public void onEnchant(EnchantItemEvent e) {
        Player player = e.getEnchanter();
        if (player != this.data.profile().getPlayer()) {
            return;
        }
        for (Map.Entry enchant : e.getEnchantsToAdd().entrySet()) {
            TypeId id = new TypeId(((Enchantment)enchant.getKey()).getKey().getNamespace(), ((Enchantment)enchant.getKey()).getKey().getKey());
            ObjectiveMeta meta = RangeFilter.with(this.meta(id), "level", ((Integer)enchant.getValue()).doubleValue());
            this.progress(1.0, meta);
        }
    }

    @Override
    public List<ObjectiveFilter> getFilters() {
        return Lists.newArrayList((Object[])new ObjectiveFilter[]{RangeFilter.rangeFilter(this.definition.getArgs(), "level")});
    }
}

