/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.event.objective.PlayerLootEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityLootObjective
extends TypedObjective {
    public EntityLootObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(EntityDeathEvent.class, this::handle, EventPriority.MONITOR);
        this.onEvent(PlayerLootEvent.class, this::handleCustomLoot, EventPriority.MONITOR);
    }

    public void handle(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getKiller() != this.data.profile().getPlayer()) {
            return;
        }
        if (entity instanceof Player) {
            return;
        }
        TypeId id = AuroraAPI.getEntityManager().resolveId((Entity)entity);
        if (id.namespace().equals("mythicmobs")) {
            return;
        }
        for (ItemStack drop : event.getDrops()) {
            TypeId typeId = AuroraAPI.getItemManager().resolveId(drop);
            this.progress(drop.getAmount(), this.meta(typeId));
        }
    }

    public void handleCustomLoot(PlayerLootEvent event) {
        if (event.getSource() == PlayerLootEvent.Source.ENTITY || event.getSource() == PlayerLootEvent.Source.ALL) {
            this.progress(event.getAmount(), this.meta(event.getType()));
        }
    }
}

