/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.events.region.RegionBlockBreakEvent;
import gg.auroramc.quests.api.event.objective.PlayerLootEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.ObjectiveMeta;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import gg.auroramc.quests.util.AnnoyingPluginUtil;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Item;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public class FarmingObjective
extends TypedObjective {
    private static final List<Material> crops = List.of(Material.WHEAT, Material.POTATOES, Material.CARROTS, Material.BEETROOTS, Material.COCOA, Material.NETHER_WART);
    private static final Set<Material> blockCrops = Set.of(Material.SUGAR_CANE, Material.CACTUS, Material.BAMBOO, Material.KELP_PLANT);
    public static final Set<Material> specialCrops = Set.of(Material.WARPED_FUNGUS, Material.CRIMSON_FUNGUS, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM_BLOCK, Material.RED_MUSHROOM_BLOCK, Material.MUSHROOM_STEM, Material.MELON, Material.PUMPKIN);

    public FarmingObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(PlayerHarvestBlockEvent.class, this::onPlayerHarvest, EventPriority.MONITOR);
        this.onEvent(RegionBlockBreakEvent.class, this::onBlockBreak, EventPriority.MONITOR);
        this.onEvent(BlockDropItemEvent.class, this::onBlockDrop, AnnoyingPluginUtil.getBlockDropItemPriority());
        this.onEvent(PlayerLootEvent.class, this::handleCustomLoot, EventPriority.MONITOR);
    }

    public void onPlayerHarvest(PlayerHarvestBlockEvent e) {
        for (ItemStack item : e.getItemsHarvested()) {
            ObjectiveMeta meta = this.meta(e.getHarvestedBlock().getLocation(), AuroraAPI.getItemManager().resolveId(item));
            this.progress(item.getAmount(), meta);
        }
    }

    public void onBlockBreak(RegionBlockBreakEvent e) {
        if (!e.isNatural()) {
            return;
        }
        if (e.getPlayerWhoBroke() != this.data.profile().getPlayer()) {
            return;
        }
        Block block = e.getBlock();
        if (specialCrops.contains(e.getBlock().getType())) {
            return;
        }
        if (blockCrops.contains(block.getType())) {
            this.progress(1.0, this.meta(block.getLocation(), block.getType()));
        }
    }

    public void onBlockDrop(BlockDropItemEvent event) {
        if (event.getPlayer() != this.data.profile().getPlayer()) {
            return;
        }
        if (crops.contains(event.getBlockState().getType())) {
            BlockData blockData = event.getBlockState().getBlockData();
            if (blockData instanceof Ageable) {
                Ageable ageable = (Ageable)blockData;
                if (ageable.getAge() != ageable.getMaximumAge()) {
                    return;
                }
                for (Item drop : event.getItems()) {
                    ItemStack item = drop.getItemStack();
                    ObjectiveMeta meta = this.meta(event.getBlock().getLocation(), AuroraAPI.getItemManager().resolveId(item));
                    this.progress(item.getAmount(), meta);
                }
            }
            return;
        }
        if (AuroraAPI.getRegionManager().isPlacedBlock(event.getBlock())) {
            return;
        }
        if (specialCrops.contains(event.getBlockState().getType())) {
            for (Item drop : event.getItems()) {
                ItemStack item = drop.getItemStack();
                ObjectiveMeta meta = this.meta(event.getBlock().getLocation(), AuroraAPI.getItemManager().resolveId(item));
                this.progress(item.getAmount(), meta);
            }
        }
    }

    public void handleCustomLoot(PlayerLootEvent event) {
        if (event.getSource() == PlayerLootEvent.Source.FARM || event.getSource() == PlayerLootEvent.Source.ALL) {
            this.progress(event.getAmount(), this.meta(event.getType()));
        }
    }
}

