/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.event.objective.PlayerCaughtFishEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

public class FishingObjective
extends TypedObjective {
    public FishingObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(PlayerFishEvent.class, this::onFishCaught, EventPriority.MONITOR);
        this.onEvent(PlayerCaughtFishEvent.class, this::onFishCaught, EventPriority.MONITOR);
    }

    public void onFishCaught(PlayerFishEvent event) {
        PlayerFishEvent.State state = event.getState();
        if (state != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item caught = (Item)entity;
        ItemStack item = caught.getItemStack();
        int amount = item.getAmount();
        TypeId id = AuroraAPI.getItemManager().resolveId(item);
        if (id.namespace().equals("minecraft") && item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
            id = TypeId.fromDefault((String)(id.id() + ":" + item.getItemMeta().getCustomModelData()));
        }
        this.progress(amount, this.meta(event.getHook().getLocation(), id));
    }

    public void onFishCaught(PlayerCaughtFishEvent event) {
        this.progress(event.getAmount(), this.meta(event.getLocation(), event.getType()));
    }
}

