/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import com.google.common.collect.Lists;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.quests.api.event.objective.PlayerKillMobEvent;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.objective.TypedObjective;
import gg.auroramc.quests.api.objective.filter.ObjectiveFilter;
import gg.auroramc.quests.api.objective.filter.RangeFilter;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LevelledMobKillObjective
extends TypedObjective {
    public LevelledMobKillObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        this.onEvent(EntityDeathEvent.class, this::handle, EventPriority.MONITOR);
        this.onEvent(PlayerKillMobEvent.class, this::onCustomMobKill, EventPriority.MONITOR);
    }

    public void handle(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player player = entity.getKiller();
        if (player == null) {
            return;
        }
        if (entity instanceof Player) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        TypeId id = AuroraAPI.getEntityManager().resolveId((Entity)entity);
        if (id.namespace().equals("mythicmobs")) {
            return;
        }
        Double level = LevelledMobKillObjective.getMobLevel(entity);
        if (level != null) {
            this.progress(1.0, RangeFilter.with(this.meta(id), "level", level));
        }
    }

    public void onCustomMobKill(PlayerKillMobEvent event) {
        if (!event.isLevelled()) {
            return;
        }
        this.progress(event.getAmount(), RangeFilter.with(this.meta(event.getMob()), "level", event.getLevel()));
    }

    @Override
    public List<ObjectiveFilter> getFilters() {
        return Lists.newArrayList((Object[])new ObjectiveFilter[]{RangeFilter.rangeFilter(this.definition.getArgs(), "level")});
    }

    public static Double getMobLevel(LivingEntity livingEntity) {
        Plugin levelledMobsPlugin = Bukkit.getPluginManager().getPlugin("LevelledMobs");
        if (levelledMobsPlugin == null) {
            return null;
        }
        NamespacedKey levelKey = new NamespacedKey(levelledMobsPlugin, "level");
        Integer level = (Integer)livingEntity.getPersistentDataContainer().get(levelKey, PersistentDataType.INTEGER);
        return level != null ? Double.valueOf(level.doubleValue()) : null;
    }
}

