/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.quests.objective;

import gg.auroramc.aurora.api.menu.Requirement;
import gg.auroramc.quests.AuroraQuests;
import gg.auroramc.quests.api.objective.Objective;
import gg.auroramc.quests.api.objective.ObjectiveDefinition;
import gg.auroramc.quests.api.profile.Profile;
import gg.auroramc.quests.api.quest.Quest;
import java.util.List;
import org.bukkit.entity.Player;

public class PlaceholderObjective
extends Objective {
    private volatile String composedRequirement;

    public PlaceholderObjective(Quest quest, ObjectiveDefinition definition, Profile.TaskDataWrapper data) {
        super(quest, definition, data);
    }

    @Override
    protected void activate() {
        if (this.placeholderToCheck() == null) {
            AuroraQuests.logger().warning("Failed to start placeholder objective with id: " + this.getId() + ", reason: args.placeholder isn't defined in config");
            return;
        }
        if (this.value() == null) {
            AuroraQuests.logger().warning("Failed to start placeholder objective with id: " + this.getId() + ", reason: args.value isn't defined in config");
            return;
        }
        this.composedRequirement = "[placeholder] " + this.placeholderToCheck() + " " + this.comparisonType() + " " + this.value();
        if (this.isAsync()) {
            this.asyncInterval(this::handler, this.getCheckingInterval(), this.getCheckingInterval());
        } else {
            this.syncInterval(this::handler, this.getCheckingInterval(), this.getCheckingInterval(), false);
        }
    }

    private void handler() {
        if (Requirement.isMet((Player)this.data.profile().getPlayer(), (String)this.composedRequirement, List.of())) {
            this.progress(1.0, this.meta());
        }
    }

    private boolean isAsync() {
        return this.definition.getArgs().getBoolean("async", false);
    }

    private int getCheckingInterval() {
        return this.definition.getArgs().getInt("check-interval", 200);
    }

    private String placeholderToCheck() {
        return this.definition.getArgs().getString("placeholder", null);
    }

    private String comparisonType() {
        return this.definition.getArgs().getString("comparison", "==");
    }

    private String value() {
        return this.definition.getArgs().getString("value", null);
    }
}

